import React from "react";
import { isUndefined } from "lodash";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import User from "../../utils/User";
import ActionButton from "src/segments/utils/ActionButton";

import "./style.scss";

const NUMBER_OF_USERS_VISIBLE = 3;

const SegmentUsersList = (props) => {
    const { users, removeUserFunc, collapsed, onExpandClick, canRemove, removeActionLabel } = props;

    const { t } = useTranslation("segments");

    if (isUndefined(users)) {
        return null;
    }

    const visibleUsers = collapsed ? users.slice(0, NUMBER_OF_USERS_VISIBLE) : users;
    const collapsible = users.length > NUMBER_OF_USERS_VISIBLE;

    const onRemoveClick = (user) => {
        const message = removeActionLabel + " " + user + "?";
        if (window.confirm(message)) {
            removeUserFunc(user);
        }
    };

    const renderCollapseLabel = () => {
        const arrow = collapsed ? "angle-down" : "angle-up";
        const text = collapsed ? t("card.more") : t("card.less");

        return (
            <div className="Expandable-text" onClick={onExpandClick}>
                <FontAwesome name={arrow} />
                {text}
            </div>
        );
    };

    return (
        <div className="SegmentUserList">
            {visibleUsers.map((user) => {
                const login = user.split("@")[0];

                return (
                    <div key={user} className="SegmentUserListItem">
                        <User login={login} />

                        {canRemove && (
                            <span className="SegmentUserListItem-remove">
                                <ActionButton
                                    action="removeUser"
                                    theme="clear"
                                    view="clear"
                                    size="s"
                                    onClick={() => onRemoveClick(user)}
                                    title={t("card.remove")}
                                />
                            </span>
                        )}
                    </div>
                );
            })}
            {collapsible && renderCollapseLabel()}
        </div>
    );
};

export default SegmentUsersList;
