import React, { useState } from "react";
import FontAwesome from "react-fontawesome";
import { Button } from "@lib/components/lego";

import { exportHasWarning } from "../utils";
import StateEditPopup from "./StateEditPopup";
import ProlongPopup from "./prolong-export-dialog/index";
import {useTranslation} from "react-i18next";

export const ExportState = {
    CREATED: "state.created",
    ACTIVE: "state.active",
    DEPRECATED: "state.deprecated",
    DISABLE_REQUESTED: "state.disable_requested",
    DISABLED: "state.disabled",
    DELETED: "state.deleted",
};

const STATE_COLOR = {
    CREATED: "yellow",
    ACTIVE: "green",
    DEPRECATED: "yellow",
    DISABLE_REQUESTED: "yellow",
    DISABLED: "red",
    DELETED: "red",
    READY: "green",
};

const State = (props) => {
    let { segmentExport, isAdmin, canEdit } = props;

    const { t } = useTranslation("segmentExport");

    const [visible, showPopup] = useState(false);
    const [prolongatePopupVisible, showProlongPopupVisible] = useState(false);

    const renderWarning = () => {
        return (
            exportHasWarning(segmentExport) && (
                <FontAwesome className="warning" name="exclamation-triangle" title="Warning: may be not active!" />
            )
        );
    };

    const renderEdit = () => {
        return (
            canEdit && (
                <span>
                    {isAdmin && (
                        <span className="State-edit-button">
                            <Button
                                view="clear"
                                title={"Edit state"}
                                onClick={() => showPopup(!visible)}
                                size="s"
                            >
                                <FontAwesome name="pencil" />
                            </Button>
                            <StateEditPopup
                                visible={visible}
                                states={ExportState}
                                segmentExport={segmentExport}
                                onClose={() => showPopup(false)}
                            />
                        </span>)}
                    {segmentExport.state === "DISABLE_REQUESTED" && (
                        <span className="State-edit-button">
                            <Button
                                view="action"
                                title={"Prolong"}
                                onClick={() => showProlongPopupVisible(!visible)}
                                size="s"
                            >
                                {t("prolongButton")}
                            </Button>
                            <ProlongPopup
                                visible={prolongatePopupVisible}
                                segmentExport={segmentExport}
                                onClose={() => showProlongPopupVisible(false)}
                            />
                        </span>
                    )}
                </span>
            )
        );
    };

    return (
        <span className="SegmentExport-state">
            <span className={"SegmentExport-state-" + STATE_COLOR[segmentExport.state]}>
                {t(ExportState[segmentExport.state])}
            </span>
            {renderWarning()}
            {renderEdit()}
        </span>
    );
};

export default State;
