import React, { useState, useEffect } from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import { Button, Select } from "@lib/components/lego";
import { getActiveIdsState, getApiState } from "../../selectors";
import { updateExportState } from "../export/exportActions";

const StateEditPopup = connect((state) => ({
    api: getApiState(state),
    segmentId: getActiveIdsState(state).segment,
}))((props) => {
    const { visible, api, segmentExport, states, segmentId, onClose, dispatch } = props;

    const { t, i18n } = useTranslation("segmentExport");
    const lang = i18n.language;

    const [exportState, setExportState] = useState();

    useEffect(() => {
        if (segmentExport) {
            setExportState(segmentExport.state);
        }
    }, [segmentExport.id]);

    const updateState = () => {
        dispatch(updateExportState(api, lang, segmentExport.id, exportState, segmentId));
        onClose();
    };

    return (
        <div className={"EditExportState-tooltip" + (visible ? "" : "-hidden")}>
            <Select
                size="s"
                view="default"
                onChange={(event) => setExportState(event.target.value)}
                value={exportState}
                options={Object.keys(states).map((each) => ({
                    value: each,
                    content: t(states[each]),
                }))}
            />

            <Button
                view="action"
                size="s"
                title={"Edit state"}
                onClick={updateState}
                className="EditExportState-button"
            >
                OK
            </Button>
            <Button view="default" size="s" title={"Close"} className="EditExportState-cancel" onClick={onClose}>
                Close
            </Button>
        </div>
    );
});

export default StateEditPopup;
