import React, {useEffect, useState} from "react";
import {useTranslation} from "react-i18next";
import {connect} from "react-redux";
import {Button, Modal, Spin} from "@lib/components/lego";
import LabModalHeader from "../../../utils/LabModalHeader";
import {getActiveIdsState, getApiState} from "../../../selectors";
import {deleteExport} from "../../actions";

import "./style.scss";

function isAudienceSegment(keywordId) {
    return keywordId === 557;
}

const DeleteExportDialog = connect((state) => ({
    api: getApiState(state),
    segmentId: getActiveIdsState(state).segment,
}))((props) => {
    const { api, segmentExport, segmentId, visible, onClose, grants, dispatch } = props;

    const { t, i18n } = useTranslation("segmentExport");
    const lang = i18n.language;

    const saveChanges = () => {
        dispatch(deleteExport(api, segmentExport.id, segmentId, lang));
    };

    return (
        <Modal theme="normal" visible={visible} onClose={onClose}>
            <LabModalHeader
                title={t("delete.header") + " " + segmentExport.id}
                hasClose
                onClose={onClose}
            />
            {!grants.loading ? (
                <div className="DeleteExportModal-container">
                    <div className="DeleteExportModal-disclaimer">{t("delete.disclaimer")}</div>
                    {isAudienceSegment(segmentExport.keywordId) && (
                        <div className="DeleteExportModal-content">
                            <div className="DeleteExportModal-disclaimer">{t("delete.audience")}</div>
                            <table className="DeleteExportModal-content-table">
                                <tbody>
                                <tr>
                                    <td className="DeleteExportModal-label">{t("delete.audienceSegment")}</td>
                                    <td className="DeleteExportModal-label">{t("delete.grants")}</td>
                                </tr>
                                <tr>
                                    <td>{segmentExport.segmentId}</td>
                                    {grants.value.length ? (
                                        <td className="DeleteExportModal-elem">
                                            <span>
                                                {grants.value.map((grant => (
                                                    <div>{grant.user_login}</div>
                                                )))}
                                            </span>
                                        </td>
                                    ) : (
                                        <td>—</td>
                                    )}
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    )}
            <div className="DeleteExportModal-edit-controls">
                <Button view="pseudo" size="m" onClick={saveChanges} className="DeleteExportModal-save-changes-button">
                    {t("delete.delete")}
                </Button>
                <Button view="pseudo" size="m" onClick={onClose}>
                    {t("delete.cancel")}
                </Button>
            </div>
            </div>
            ) : (
                <div className="DeleteExport-loading">
                    <Spin progress view="default" size="m" />
                </div>
            )}
        </Modal>
    );
});

export default DeleteExportDialog;
