import React, { useEffect } from "react";
import { connect } from "react-redux";
import { isUndefined, startsWith as _startsWith } from "lodash";

import DummyInfo from "./DummyInfo";
import GroupInfo from "./GroupInfo";
import SegmentInfo from "./SegmentInfo";
import { getActiveIdsState, getActiveSegmentAttributesState } from "../selectors";

import "./style.scss";
import { getApiState } from "../../selectors";
import { fetchSegment } from "../actions";
import { useTranslation } from "react-i18next";

const SegmentCard = connect((state) => ({
    segmentItem: getActiveSegmentAttributesState(state),
    activeSegmentId: getActiveIdsState(state).segment,
    api: getApiState(state),
}))((props) => {
    const { segmentItem, activeSegmentId, api, dispatch } = props;

    const { i18n } = useTranslation();

    const isSegmentItemGroup =
        !isUndefined(activeSegmentId) &&
        (_startsWith(activeSegmentId, "root") || _startsWith(activeSegmentId, "group-"));

    useEffect(() => {
        if (!isSegmentItemGroup) {
            dispatch(fetchSegment(api, i18n.language, activeSegmentId));
        }
    }, [activeSegmentId]);
    
    const renderInfo = () => {
        if (isSegmentItemGroup) {
            return (
                <div>
                    <GroupInfo segment={segmentItem} />
                    <DummyInfo />
                </div>
            );
        } else if (!isUndefined(segmentItem) ) {
            return <SegmentInfo />;
        } else {
            return <DummyInfo />;
        }
    };

    return <div className="SegmentCard">{renderInfo()}</div>;
});

export default React.memo(SegmentCard);
