import React, { useState, useEffect } from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import { Button, Modal } from "@lib/components/lego";
import { getActiveIdsState, getApiState } from "../../../selectors";
import { updateNextActivityCheckTimestamp, updateExportState } from "../../export/exportActions";

import "./style.scss";

const ProlongPopup = connect((state) => ({
    api: getApiState(state),
    segmentId: getActiveIdsState(state).segment,
}))((props) => {
    const { visible, segmentExport, onClose, api, segmentId, dispatch } = props;

    const { t, i18n } = useTranslation("segmentExport");
    const lang = i18n.language;

    const prolong = () => {
        var time = new Date().getTime() + 1000 * 60 * 60 * 24 * 30;
        dispatch(updateExportState(api, lang, segmentExport.id, "ACTIVE", segmentId));
        dispatch(updateNextActivityCheckTimestamp(api, segmentExport.id, time));
        onClose();
    };

    return (
        <Modal theme="normal" visible={visible} onClose={onClose}>
            <div className="Prolong-container">
                <div className="Prolong-text">
                    {t("prolongMessage")}
                </div>
                <div className="Prolong-controls">
                    <Button
                        view="action"
                        size="s"
                        title={"Edit state"}
                        onClick={prolong}
                        className="Prolong-button"
                    >
                        {t("prolongButton")}
                    </Button>
                    <Button view="default" size="s" title={"Close"} className="Prolong-button" onClick={onClose}>
                        {t("close")}
                    </Button>
                </div>
            </div>
        </Modal>
    );
});

export default ProlongPopup;
