import React, { useEffect, useState } from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import { Button, Textarea } from "@lib/components/lego";
import Link from "@lib/components/link";
import Loading from "@lib/components/loading";

import { getEnvTypeState } from "../../../selectors";

import "./style.scss";

const TankerKeyView = connect((state) => ({
    env: getEnvTypeState(state),
}))((props) => {
    const { env, tankerKey, value, loading, label, createWelcome, createFunc } = props;

    const [readyToCreate, setReadyToCreate] = useState(false);
    const [updatedValue, setUpdatedValue] = useState("");

    const branch = env === "production" ? "master" : "testing";

    useEffect(() => {
        setUpdatedValue(value.ru.text);
    }, [value]);

    const { t } = useTranslation("segments");

    const isApproved = (status) => status === "approved";
    const requiresTranslation = (status) => status === "requires_translation";

    const isApprovedRu = isApproved(value.ru.status);
    const requiresTranslationRu = requiresTranslation(value.ru.status);
    const isApprovedEn = isApproved(value.en.status);
    const requiresTranslationEn = requiresTranslation(value.en.status);

    const editUrl = `https://tanker-beta.yandex-team.ru/?project=crypta&branch=${branch}&keyset=profile&key=${tankerKey}`;

    return (
        <div className="TankerKeyView">
            {isEmpty(tankerKey) && (
                <div className="TankerKeyView-create">
                    {!readyToCreate && (
                        <>
                            <div className="TankerKeyView-create-welcome">{createWelcome}</div>
                            <Button view="action" size="s" onClick={() => setReadyToCreate(true)}>
                                {t("tanker.create.action")}
                            </Button>
                        </>
                    )}

                    {readyToCreate && (
                        <div className="TankerKeyView-create-form">
                            <div className="TankerKeyView-create-form-label">{label}</div>
                            <Textarea
                                view="default"
                                size="s"
                                rows={2}
                                value={updatedValue}
                                onChange={(event) => setUpdatedValue(event.target.value)}
                                placeholder={t("tanker.create.enterValue")}
                                hasClear
                            />
                            <Button view="action" size="s" onClick={createFunc}>
                                {t("tanker.create.save")}
                            </Button>
                        </div>
                    )}
                </div>
            )}

            {!isEmpty(tankerKey) && (
                <Loading loaded={!loading} size="s">
                    <div className="TankerKeyView-content">
                        <div className="TankerKeyView-label">{label}</div>
                        <div className="TankerKeyView-translation">
                            <div className="TankerKeyView-translated">
                                <span className="TankerKeyView-language-label">Ru:</span>
                                {value.ru.text}
                            </div>
                            <div className="TankerKeyView-status">
                                {isApprovedRu && (
                                    <div className="TankerKeyView-status-approved">{t("tanker.approved")}</div>
                                )}
                                {requiresTranslationRu && (
                                    <div className="TankerKeyView-status-requires-translation">
                                        {t("tanker.requiresTranslation")}
                                    </div>
                                )}
                            </div>
                        </div>
                        <div className="TankerKeyView-translation">
                            <div className="TankerKeyView-translated">
                                <span className="TankerKeyView-language-label">En:</span>
                                {value.en.text}
                            </div>
                            <div className="TankerKeyView-status">
                                {isApprovedEn && (
                                    <div className="TankerKeyView-status-approved">{t("tanker.approved")}</div>
                                )}
                                {requiresTranslationEn && (
                                    <div className="TankerKeyView-status-requires-translation">
                                        {t("tanker.requiresTranslation")}
                                    </div>
                                )}
                            </div>
                        </div>

                        <div className="TankerKeyView-tanker-link">
                            <Link href={editUrl} target="_blank">
                                {t("tanker.edit")} <FontAwesome name="external-link" />
                            </Link>
                        </div>
                    </div>
                </Loading>
            )}
        </div>
    );
});

export default TankerKeyView;
