import { createAction } from "redux-actions";
import {
    addErrorNotification,
    addInfoNotification,
    addSuccessNotification,
} from "../../../utils/notifications/notificationsState";

function fetchByTankerKey(api, tankerKey) {
    return (dispatch) => {
        return api.then((api) => api.apis.lab.getTranslationsByKey).then((method) => method({ key: tankerKey }));
    };
}

export const requestTankerName = createAction("request tanker name");
export const receiveTankerName = createAction("receive tanker name");
export const failTankerName = createAction("fail tanker name");

export function fetchNameByTankerKey(api, nameKey) {
    return (dispatch) => {
        dispatch(requestTankerName());

        return dispatch(fetchByTankerKey(api, nameKey))
            .then((response) => {
                dispatch(receiveTankerName(response.obj));
            })
            .catch((error) => {
                dispatch(failTankerName());

                if (error.status !== 404) {
                    dispatch(addErrorNotification(error, "Fail fetching name from Tanker"));
                }
            });
    };
}

export const requestTankerDescription = createAction("request tanker description");
export const receiveTankerDescription = createAction("receive tanker description");
export const failTankerDescription = createAction("fail tanker description");

export function fetchDescriptionByTankerKey(api, descriptionKey) {
    return (dispatch) => {
        return dispatch(fetchByTankerKey(api, descriptionKey))
            .then((response) => {
                dispatch(receiveTankerDescription(response.obj));
            })
            .catch((error) => {
                dispatch(failTankerDescription());

                if (error.status !== 404) {
                    dispatch(addErrorNotification(error, "Failed fetching description from Tanker"));
                }
            });
    };
}

export const requestSaveTankerValues = createAction("request save tanker values");
export const receiveSaveTankerValues = createAction("receive save tanker values");
export const failSaveTankerValues = createAction("fail tanker values");

export function storeTankerValues(api, segmentId, name, description, skipTranslation) {
    return (dispatch) => {
        dispatch(requestSaveTankerValues());

        return api
            .then((api) => api.apis.lab.createSegmentKeysInTanker)
            .then((method) =>
                method({ id: segmentId, name: name, description: description, skipTranslation: skipTranslation })
            )
            .then((response) => {
                dispatch(receiveSaveTankerValues(response.obj));
                dispatch(addSuccessNotification("Keys created"));
            })
            .catch((error) => {
                dispatch(failSaveTankerValues());
                dispatch(addErrorNotification(error, "Fail saving tanker values"));
            });
    };
}

export const requestDeleteTankerKeys = createAction("request delete tanker keys");
export const receiveDeleteTankerKeys = createAction("receive delete tanker keys");
export const failDeleteTankerKeys = createAction("fail delete tanker keys");

export function deleteTankerKeys(api, segmentId) {
    return (dispatch) => {
        dispatch(requestDeleteTankerKeys());

        return api
            .then((api) => api.apis.lab.deleteSegmentKeysInTanker)
            .then((method) => method({ segmentId: segmentId }))
            .then((response) => {
                dispatch(receiveDeleteTankerKeys());
                dispatch(addSuccessNotification("Translations deleted"));
            })
            .catch((error) => {
                dispatch(failDeleteTankerKeys());
                dispatch(addErrorNotification(error, "Fail deleting keys from tanker"));
            });
    };
}

export const requestSaveTankerName = createAction("request save tanker name");
export const receiveSaveTankerName = createAction("receive save tanker name");
export const failSaveTankerName = createAction("fail save tanker name");

export function storeTankerName(api, segmentId, name) {
    return (dispatch) => {
        dispatch(requestSaveTankerName());
    };
}

export const requestSaveTankerDescription = createAction("request save tanker description");
export const receiveSaveTankerDescription = createAction("receive save tanker description");
export const failSaveTankerDescription = createAction("fail save tanker description");

export function storeTankerDescription(api, segmentId, description) {
    return (dispatch) => {
        dispatch(requestSaveTankerDescription());
    };
}

export const resetTankerModalValues = createAction("reset tanker modal values");
