import { handleActions } from "redux-actions";
import {
    failDeleteTankerKeys,
    failSaveTankerValues,
    failTankerDescription,
    failTankerName,
    receiveDeleteTankerKeys,
    receiveSaveTankerValues,
    receiveTankerDescription,
    receiveTankerName,
    requestDeleteTankerKeys,
    requestSaveTankerValues,
    requestTankerDescription,
    requestTankerName,
    resetTankerModalValues,
} from "./actions";

const DEFAULT_STATE = {
    name: {
        value: {
            ru: {
                text: "",
                state: "",
            },
            en: {
                text: "",
                state: "",
            },
        },
        loading: false,
        error: false,
    },
    description: {
        value: {
            ru: {
                text: "",
                state: "",
            },
            en: {
                text: "",
                state: "",
            },
        },
        loading: false,
        error: false,
    },
    save: {
        result: {},
        loading: false,
        error: false,
    },
    delete: {
        result: {},
        loading: false,
        error: false,
    },
};

export const tankerReducer = handleActions(
    {
        [requestTankerName]: (state) => ({
            ...state,
            name: {
                value: DEFAULT_STATE.name.value,
                loading: true,
                error: false,
            },
        }),
        [receiveTankerName]: (state, { payload }) => ({
            ...state,
            name: {
                value: payload,
                loading: false,
                error: false,
            },
        }),
        [failTankerName]: (state) => ({
            ...state,
            name: {
                value: DEFAULT_STATE.name.value,
                loading: false,
                error: true,
            },
        }),

        [requestTankerDescription]: (state) => ({
            ...state,
            description: {
                value: DEFAULT_STATE.description.value,
                loading: true,
                error: false,
            },
        }),
        [receiveTankerDescription]: (state, { payload }) => ({
            ...state,
            description: {
                value: payload,
                loading: false,
                error: false,
            },
        }),
        [failTankerDescription]: (state) => ({
            ...state,
            description: {
                value: DEFAULT_STATE.description.value,
                loading: false,
                error: true,
            },
        }),

        [requestSaveTankerValues]: (state) => ({
            ...state,
            save: {
                result: {},
                loading: true,
                error: false,
            },
        }),
        [receiveSaveTankerValues]: (state, { payload }) => ({
            ...state,
            save: {
                result: payload,
                loading: false,
                error: false,
            },
        }),
        [failSaveTankerValues]: (state) => ({
            ...state,
            save: {
                result: {},
                loading: false,
                error: true,
            },
        }),

        [requestDeleteTankerKeys]: (state) => ({
            ...state,
            delete: {
                loading: true,
                error: false,
            },
        }),
        [receiveDeleteTankerKeys]: (state) => ({
            ...state,
            delete: {
                loading: false,
                error: false,
            },
        }),
        [failDeleteTankerKeys]: (state) => ({
            ...state,
            delete: {
                loading: false,
                error: true,
            },
        }),

        [resetTankerModalValues]: () => DEFAULT_STATE,
    },
    DEFAULT_STATE
);
