import React, { useState } from "react";
import { useTranslation } from "react-i18next";
import { connect, useDispatch } from "react-redux";
import { Modal, Button, Spin } from "@lib/components/lego";
import LabModalHeader from "../../utils/LabModalHeader";
import { getActiveSegmentAttributesState } from "../selectors";
import audienceLittlePic from "../../images/audience.png";
import { getApiState } from "../../selectors";
import Failable from "../../utils/Failable";
import { createUserExport, resetCreateUserExport, setCreateUserExportModalVisibility } from "./exportActions";
import { getUserExportModalVisibility, getUserExportState } from "./selectors";

import "./style.scss";

const CreateSegmentExportModal = connect((state) => ({
    api: getApiState(state),
    visible: getUserExportModalVisibility(state),
    segment: getActiveSegmentAttributesState(state),
    userExport: getUserExportState(state),
}))((props) => {
    const { api, visible, segment, userExport } = props;

    const [description, setDescription] = useState("");

    const dispatch = useDispatch();
    const { t, i18n } = useTranslation("segmentExport");

    const close = () => {
        dispatch(setCreateUserExportModalVisibility(false));
        dispatch(resetCreateUserExport());
    };

    const exportSegment = (keywordId) => {
        if (!userExport.loading && !userExport.error) {
            dispatch(createUserExport(api, i18n.language, segment.id, keywordId));
        }
    };

    const exportBigB = () => {
        exportSegment(549);
        close();
    };

    const exportAudience = () => {
        exportSegment(557);
        close();
    };

    const showBigbDescription = () => setDescription(t("bigbExportHint"));
    const showAudienceDescription = () => setDescription(t("audienceExportHint"));
    const resetDescription = () => setDescription("");

    const cryptaLogo = (
        <div className="CreateSegmentExportModal-crypta-logo">
            <div className="CreateSegmentExportModal-crypta-logo-title">Crypta</div>
            <div className="CreateSegmentExportModal-crypta-logo-keyword">keyword 549</div>
        </div>
    );

    return (
        <Modal theme="normal" visible={visible} onClose={close}>
            <LabModalHeader title={t("new")} onClose={close} hasClose />

            <div className="CreateSegmentExportModal-container">
                <div className="CreateSegmentExportModal-buttons-area">
                    <CreateExportButton
                        logo={cryptaLogo}
                        text={t("bigbExport")}
                        action={exportBigB}
                        showInfo={showBigbDescription}
                        clearInfo={resetDescription}
                    />
                    <CreateExportButton
                        logo={<img alt={t("audienceExport")} src={audienceLittlePic} />}
                        text={t("audienceExport")}
                        action={exportAudience}
                        showInfo={showAudienceDescription}
                        clearInfo={resetDescription}
                    />
                </div>

                <div className="CreateSegmentExportModal-description-area">{description}</div>

                <div className="CreateSegmentExportModal-info-area">
                    <Failable failed={userExport.error} errorMessage={`${t("error")} segmentId=${segment.id}`}>
                        {userExport.loading ? (
                            <Spin progress size="l" />
                        ) : userExport.done ? (
                            <div>
                                <div>{t("success")}</div>
                                <div>
                                    <Button view="default" size="m" onClick={close}>
                                        {t("close")}
                                    </Button>
                                </div>
                            </div>
                        ) : (
                            <div />
                        )}
                    </Failable>
                </div>
            </div>
        </Modal>
    );
});

const CreateExportButton = (props) => {
    const { logo, text, action, showInfo, clearInfo } = props;

    return (
        <div className="CreateExportButton-container" onClick={action} onMouseOver={showInfo} onMouseLeave={clearInfo}>
            <div className="CreateExportButton-logo">{logo}</div>
            <div className="CreateExportButton-text">{text}</div>
        </div>
    );
};

export default CreateSegmentExportModal;
