import { createAction } from "redux-actions";
import { reachGoal } from "metrika";
import { addErrorNotification } from "../../utils/notifications/notificationsState";
import { fetchSegment, fetchSegments } from "../actions";

export const setCreateUserExportModalVisibility = createAction("set create user export modal visibility");
export const setCreateAdminExportModalVisibility = createAction("set create admin export modal visibility");

export function createAdminExport(
    api,
    lang,
    segmentId,
    type,
    exportKeywordId,
    exportSegmentId,
    exportCryptaId = false
) {
    return (dispatch) => {
        return api
            .then((api) => api.apis.lab.createSegmentExport)
            .then((method) =>
                method({
                    lang: lang,
                    segmentId: segmentId,
                    type: type,
                    exportKeywordId: exportKeywordId,
                    exportSegmentId: exportSegmentId,
                    exportCryptaId: exportCryptaId,
                })
            )
            .then((response) => {
                dispatch(reachGoal("createExportSuccess"));
                dispatch(fetchSegment(api, lang, segmentId));
            })
            .catch((error) => {
                dispatch(reachGoal("createExportFailed"));
                dispatch(addErrorNotification(error, "Failed to create export"));
            });
    };
}

export const requestCreateUserExport = createAction("request create user export");
export const receiveCreateUserExport = createAction("receive create user export");
export const failCreateUserExport = createAction("fail create user export");
export const resetCreateUserExport = createAction("reset create user export");

export function createUserExport(api, lang, segmentId, keywordId) {
    return (dispatch) => {
        dispatch(requestCreateUserExport());

        return api
            .then((api) => api.apis.lab.createUserSegmentExport)
            .then((method) => method({ segmentId: segmentId, keywordId: keywordId }))
            .then((response) => {
                dispatch(receiveCreateUserExport());
                dispatch(reachGoal("createUserExportSuccess"));
                dispatch(fetchSegment(api, lang, segmentId));
            })
            .catch((error) => {
                dispatch(reachGoal("createUserExportFailed"));
                dispatch(failCreateUserExport({ segmentId: segmentId, keywordId: keywordId }));
            });
    };
}

export function updateExportState(api, lang, exportId, exportState, segmentId) {
    return (dispatch) => {
        return api
            .then((api) => api.apis.lab.updateExportState)
            .then((method) => method({ id: exportId, state: exportState }))
            .then(() => {
                dispatch(fetchSegment(api, lang, segmentId));
                dispatch(reachGoal("updateExportStateSuccess"));
            })
            .catch((error) => {
                dispatch(addErrorNotification(error, "Failed to update state"));
                dispatch(reachGoal("updateExportStateFailed"));
            });
    };
}

export function updateNextActivityCheckTimestamp(api, exportId, time) {
    return (dispatch) => {
        console.log("updating");
        return api
            .then((api) => api.apis.lab.updateExportNextActivityCheckTs)
            .then((method) => method({ id: exportId, timestamp:  time}))
            .catch((error) => {
                dispatch(addErrorNotification(error, "Failed to update activity check timestamp"));
            });
    };
}
