import { handleActions } from "redux-actions";
import {
    failCreateUserExport,
    receiveCreateUserExport,
    requestCreateUserExport,
    resetCreateUserExport,
    setCreateAdminExportModalVisibility,
    setCreateUserExportModalVisibility,
} from "./exportActions";

export const segmentExportsReducer = handleActions(
    {
        [setCreateUserExportModalVisibility]: (state, { payload }) => ({
            ...state,
            createUserExportModalVisible: payload,
        }),
        [setCreateAdminExportModalVisibility]: (state, { payload }) => ({
            ...state,
            createAdminExportModalVisible: payload,
        }),
        [requestCreateUserExport]: (state) => ({
            ...state,
            userExport: {
                loading: true,
                error: false,
                done: false,
            },
        }),
        [receiveCreateUserExport]: (state) => ({
            ...state,
            userExport: {
                loading: false,
                error: false,
                done: true,
            },
        }),
        [failCreateUserExport]: (state) => ({
            ...state,
            userExport: {
                loading: false,
                error: true,
                done: false,
            },
        }),
        [resetCreateUserExport]: (state) => ({
            ...state,
            userExport: {
                loading: false,
                error: false,
                done: false,
            },
        }),
    },
    {
        createUserExportModalVisible: false,
        createAdminExportModalVisible: false,
        userExport: {},
    }
);
