import React from "react";
import { useTranslation } from "react-i18next";
import { connect, useDispatch } from "react-redux";
import { Modal } from "@lib/components/lego";
import { getActiveExportIdState, getSegmentsModalsState } from "../selectors";
import { setExpressionsModalVisibility } from "../actions";
import Failable from "../../utils/Failable";
import ExpressionsConditionCard from "./ExpressionsConditionCard";
import LabModalHeader from "../../utils/LabModalHeader";

import "./ExpressionsModal.scss";

const ExpressionsModal = connect((state) => ({
    visible: getSegmentsModalsState(state).expressions,
    exportId: getActiveExportIdState(state),
}))((props) => {
    const { visible, error, errorMessage, exportId } = props;

    const dispatch = useDispatch();
    const { t } = useTranslation("segments");

    const hide = () => dispatch(setExpressionsModalVisibility(false));

    return (
        <Modal theme="normal" visible={visible} onClose={hide}>
            <LabModalHeader title={t("expression.header")} hasClose onClose={hide} info={exportId ? exportId : ""} />
            {
                // TODO: add valid error
            }
            <Failable failed={error} errorMessage={errorMessage}>
                <div className="ExpressionsModal-container">
                    <div className="ExpressionsModal-content">
                        <ExpressionsConditionCard />
                    </div>
                </div>
            </Failable>
        </Modal>
    );
});

export default ExpressionsModal;
