import React from "react";
import { connect, useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import { RadioButton } from "@lib/components/lego";

import { getDisplayModeState } from "./filterSelectors";
import { DISPLAY_MODE, setDisplayMode, setSearchPanelVisibility } from "./filterActions";

import "./style.scss";

const DisplayModeSelector = connect((state) => ({
    displayMode: getDisplayModeState(state),
}))((props) => {
    const { displayMode } = props;

    const dispatch = useDispatch();
    const { t } = useTranslation("segments");

    const setMode = (value) => {
        dispatch(setDisplayMode(value));
        if (value === DISPLAY_MODE.filtered) {
            dispatch(setSearchPanelVisibility(true));
        } else {
            dispatch(setSearchPanelVisibility(false));
        }
    };

    const allSegmentsButton = (
        <div className="DisplayModeSelector-radio">
            <FontAwesome name="sitemap" />
            <span className="DisplayModeSelector-label normal-screen-icon">{t("filter.allSegments")}</span>
        </div>
    );

    const mySegmentsButton = (
        <div className="DisplayModeSelector-radio">
            <FontAwesome name="list" />
            <span className="DisplayModeSelector-label normal-screen-icon">{t("filter.mySegments")}</span>
        </div>
    );

    const filterSegmentsButton = (
        <div className="DisplayModeSelector-radio">
            <FontAwesome name="search" />
            <span className="DisplayModeSelector-label normal-screen-icon">{t("filter.search")}</span>
        </div>
    );

    const displayModeOptions = () => {
        return [
            {
                value: DISPLAY_MODE.tree,
                children: allSegmentsButton,
            },
            {
                value: DISPLAY_MODE.my,
                children: mySegmentsButton,
            },
            {
                value: DISPLAY_MODE.filtered,
                children: filterSegmentsButton,
            },
        ];
    };

    return (
        <span className="DisplayModeSelector">
            <RadioButton
                size="m"
                view="default"
                value={displayMode}
                onChange={(event) => setMode(event.target.value)}
                options={displayModeOptions()}
            />
        </span>
    );
});

export default DisplayModeSelector;
