import React from "react";
import FontAwesome from "react-fontawesome";

import "./style.scss";

const Tag = (props) => {
    const { onClose } = props;
    return (
        <span className="Tag">
            <span className="Tag-value">{props.children}</span>

            {onClose && (
                <span className="Tag-close">
                    <FontAwesome name="times-circle" onClick={onClose} />
                </span>
            )}
        </span>
    );
};

export default Tag;
