import React, { useEffect } from "react";
import { Button, TextInput } from "@lib/components/lego";
import FontAwesome from "react-fontawesome";
import { useTranslation } from "react-i18next";

const TagsInput = (props) => {
    const { currentValue, onChange, addTag } = props;

    const { t } = useTranslation("segments");

    useEffect(() => {
        const listener = (event) => {
            if (event.code === "Enter" || event.code === "NumpadEnter") {
                addTag();
            }
        };
        document.addEventListener("keydown", listener);
        return () => {
            document.removeEventListener("keydown", listener);
        };
    }, [currentValue]);

    return (
        <div className="TagsInput">
            <TextInput
                className="SearchOptions-input"
                view="default"
                value={currentValue}
                size="s"
                hasClear
                baseline
                onChange={onChange}
                placeholder={t("search.tag")}
            />

            <Button className="SearchOptions-tag-add" size="s" view="clear" onClick={addTag}>
                <FontAwesome name="plus" />
            </Button>
        </div>
    );
};

export default TagsInput;
