import { handleActions } from "redux-actions";
import { DISPLAY_MODE, filterUserSegments, setDisplayMode, setSearchPanelVisibility } from "./filterActions";

export const segmentsFilterReducer = handleActions(
    {
        [setDisplayMode]: (state, { payload }) => ({
            ...state,
            displayMode: payload,
        }),

        [setSearchPanelVisibility]: (state, { payload }) => ({
            ...state,
            searchPanel: {
                ...state.searchPanel,
                visible: payload,
            },
        }),
    },
    {
        displayMode: DISPLAY_MODE.tree,
        searchPanel: {
            visible: false,
        },
    }
);
