import React from "react";
import { useTranslation } from "react-i18next";
import { connect, useDispatch } from "react-redux";
import { Modal } from "@lib/components/lego";
import { getSegmentsModalsState } from "../selectors";
import { setLalModalVisibility } from "../actions";
import Failable from "../../utils/Failable";
import LalCard from "./LalCard";
import LabModalHeader from "../../utils/LabModalHeader";

import "./LalModal.scss";
import Link from "@lib/components/link";
import helpPic from "../../images/help.svg";

const LABORATORY_LAL_HELP_URL = "https://docs.yandex-team.ru/crypta/lab/constructor/lal";

const LalModal = connect((state) => ({
    visible: getSegmentsModalsState(state).lal,
}))((props) => {
    const { visible, error, errorMessage } = props;

    const dispatch = useDispatch();
    const { t } = useTranslation("segments");

    const hide = () => dispatch(setLalModalVisibility(false));

    return (
        <Modal theme="normal" visible={visible} onClose={hide}>
            <LabModalHeader
                title={t("lal.header")}
                info={
                    <Link
                        className=""
                        href={LABORATORY_LAL_HELP_URL}
                        title={t("lal.userGuide")}
                        target="_blank"
                    >
                        <img alt="" className="LalModal-help-pic" src={helpPic} />
                    </Link>
                }
                hasClose
                onClose={hide}
            />
            {
                // TODO: add valid error
            }
            <Failable failed={error} errorMessage={errorMessage}>
                <div className="LalModal-container">
                    <div className="LalModal-content">
                        <LalCard/>
                    </div>
                </div>
            </Failable>
        </Modal>
    );
});

export default LalModal;
