import React from "react";
import { orderBy as _orderBy } from "lodash";
import { receiveSegmentInfo } from "../actions";
import { useDispatch } from "react-redux";
import { DISPLAY_MODE, setDisplayMode, setSearchPanelVisibility } from "../filter/filterActions";

const MenuItem = (props) => {
    const { group, activeGroupId, level, depth, onClick, isVisible } = props;

    const dispatch = useDispatch();

    const isActive = group.id === activeGroupId;
    const children = level < depth ? group.children : [];
    const sortedChildren = _orderBy(children, ["priority", "name"], ["desc", "asc"]);

    const onItemClick = () => {
        onClick(group.id);
        dispatch(receiveSegmentInfo(group));
        dispatch(setDisplayMode(DISPLAY_MODE.tree));
        dispatch(setSearchPanelVisibility(false));
    };

    return isVisible && [
        <div key={group.id} className={`menu-item${isActive ? "-active" : ""} level-${level}`} onClick={onItemClick}>
            {group.name}
        </div>,
        ...sortedChildren.map((childGroup) => {
            return (
                <MenuItem
                    key={childGroup.id}
                    group={childGroup}
                    activeGroupId={activeGroupId}
                    level={level + 1}
                    depth={depth}
                    onClick={onClick}
                    isVisible={childGroup.isVisible}
                />
            );
        }),
    ];
};

export default MenuItem;
