import React from "react";
import { connect } from "react-redux";
import { get as _get, sortBy as _sortBy } from "lodash";

import { pushQuery } from "../../actions";
import { getActiveIdsState, getSegmentsTreeRootState } from "../selectors";
import MenuItem from "./MenuItem";

import "./style.scss";

const GROUPS_DEPTH = {
    "root-crypta": 1,
};

const SegmentsMenu = connect((state) => ({
    activeGroupId: getActiveIdsState(state).group,
    rootSegment: getSegmentsTreeRootState(state),
}))((props) => {
    const { activeGroupId, rootSegment, dispatch } = props;

    const onClick = (value) => {
        const newActive = {
            group: value,
            segment: value,
            export: undefined,
        };
        dispatch(pushQuery(newActive));
    };

    const topGroups = rootSegment ? rootSegment.children : [];
    const sortedTopGroups = _sortBy(
        topGroups,
        (x) => x.priority,
        (x) => x.name
    ).reverse();

    return (
        <div className="SegmentsMenu">
            {sortedTopGroups.map((group) => {
                return (
                    <MenuItem
                        key={group.id}
                        group={group}
                        activeGroupId={activeGroupId}
                        level={0}
                        depth={_get(GROUPS_DEPTH, group.id, 0)}
                        onClick={onClick}
                        isVisible={group.isVisible}
                    />
                );
            })}
        </div>
    );
});

export default SegmentsMenu;
