import { handleActions } from "redux-actions";
import {
    concat as _concat,
    forEach as _forEach,
    fromPairs as _fromPairs,
    isEmpty,
    map as _map,
    some as _some,
} from "lodash";

import {
    failGrantsForAudienceSegment,
    failMatchSearchItems,
    failMatchSegmentCondition,
    failNotLocalizedSegment,
    failProcessingData,
    failRequestConditionApproval,
    failRuleEstimateCoverage,
    failRuleEstimateStats,
    failRuleRevisionEstimateCoverage,
    failRuleRevisionEstimateStats,
    failSegmentByExportId,
    failSegmentExport,
    failSegmentsAttributes,
    failSegmentsData,
    failSegmentStats,
    failStoreLal,
    failStoreExpressions,
    failUpdateNameAndDescription,
    finishProcessingData,
    handleEditButtonClick,
    handleSearch,
    hideRuleEstimateStatsModal,
    hideRuleModal,
    hideRuleRevisionEstimateStatsModal,
    hideSegmentStatsModal,
    invalidateGrantsForManyAudienceSegments,
    receiveGrantsForAudienceSegment,
    receiveGroups,
    receiveMatchSearchItems,
    receiveMatchSegmentConditions,
    receiveNotLocalizedSegment,
    receiveRequestConditionApproval,
    receiveRule,
    receiveRuleEstimateCoverage,
    receiveRuleEstimateStats,
    receiveRuleRevisionEstimateCoverage,
    receiveRuleRevisionEstimateStats,
    receiveSegmentByExportId,
    receiveSegmentExport,
    receiveSegments,
    receiveSegmentsAttributes,
    receiveSegmentsData,
    receiveSegmentsDone,
    receiveSegmentStats,
    receiveStoreLal,
    receiveStoreExpressions,
    receiveUpdateNameAndDescription,
    refreshRule,
    requestGrantsForAudienceSegment,
    requestMatchSearchItems,
    requestMatchSegmentConditions,
    requestNotLocalizedSegment,
    requestRequestConditionApproval,
    requestRuleEstimateCoverage,
    requestRuleEstimateStats,
    requestRuleRevisionEstimateCoverage,
    requestRuleRevisionEstimateStats,
    requestUpdateNameAndDescription,
    resetMatchSegmentConditions,
    setActiveCondition,
    setExpressionsModalVisibility,
    setLalModalVisibility,
    showExportTooltip,
    showRuleEstimateStatsModal,
    showRuleModal,
    showRuleRevisionEstimateStatsModal,
    showSegmentStatsModal,
    startProcessingData,
    updateSegmentToMove,
} from "actions";
import {
    closeExportTagsModal,
    failDeleteExpressions,
    failDeleteLal,
    failExportInfo,
    failSegmentInfo,
    hideExportTooltip,
    openExportTagsModal,
    receiveDeleteExpressions,
    receiveDeleteLal,
    receiveExportInfo,
    receiveExportsToSegments,
    receiveSegmentInfo,
    requestDeleteExpressions,
    requestDeleteLal,
    requestExportInfo,
    requestSegmentByExportId,
    requestSegmentExport,
    requestSegmentInfo,
    requestSegmentsAttributes,
    requestSegmentsData,
    requestSegmentStats,
    requestStoreExpressions,
    requestStoreLal,
    resetRequestConditionApproval,
    resetSearch,
    setActiveSegmentExportId,
    setActiveSegmentExportTags,
    setCreateSegmentModalVisibility,
    setRequestApprovalVisibility,
    setTankerModalVisibility,
} from "./actions";
import { setAudienceSegmentFeaturesModalVisibility } from "./audience/audienceActions";

export const segmentsReducer = handleActions(
    {
        [requestGrantsForAudienceSegment]: (state, { payload }) => ({
            ...state,
            audienceSegmentsToGrants: {
                ...state.audienceSegmentsToGrants,
                [payload]: {
                    loading: true,
                    error: false,
                    grants: [],
                }
            },
        }),
        [receiveGrantsForAudienceSegment]: (state, { payload }) => ({
            ...state,
            audienceSegmentsToGrants: {
                ...state.audienceSegmentsToGrants,
                [payload.segmentId]: {
                    loading: false,
                    error: false,
                    grants: payload.grants,
                }
            },
        }),
        [failGrantsForAudienceSegment]: (state, { payload }) => ({
            ...state,
            audienceSegmentsToGrants: {
                ...state.audienceSegmentsToGrants,
                [payload.segmentId]: {
                    loading: false,
                    error: true,
                    grants: [],
                }
            },
        }),

        [invalidateGrantsForManyAudienceSegments]: (state) => ({
            ...state,
            audienceSegmentsToGrants: {},
        }),

        [requestSegmentInfo]: (state) => ({
            ...state,
            activeSegmentInfo: {
                ...state.activeSegmentInfo,
                loading: true,
                error: false,
            },
        }),
        [receiveSegmentInfo]: (state, { payload }) => ({
            ...state,
            activeSegmentInfo: {
                value: payload,
                loading: false,
                error: false,
            },
        }),
        [failSegmentInfo]: (state) => ({
            ...state,
            activeSegmentInfo: {
                ...state.activeSegmentInfo,
                loading: false,
                error: true,
            },
        }),

        [requestNotLocalizedSegment]: (state) => ({
            ...state,
            notLocalizedSegment: {
                loading: true,
                value: {},
                error: false,
            },
        }),
        [receiveNotLocalizedSegment]: (state, { payload }) => ({
            ...state,
            notLocalizedSegment: {
                loading: false,
                value: payload,
                error: false,
            },
        }),

        [failNotLocalizedSegment]: (state) => ({
            ...state,
            notLocalizedSegment: {
                loading: false,
                value: {},
                error: true,
            },
        }),

        [requestUpdateNameAndDescription]: (state) => ({
            ...state,
            updatedNameAndDescription: {
                loading: false,
                value: {},
                error: false,
            },
        }),
        [receiveUpdateNameAndDescription]: (state, { payload }) => ({
            ...state,
            updatedNameAndDescription: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failUpdateNameAndDescription]: (state) => ({
            ...state,
            updatedNameAndDescription: {
                loading: false,
                value: {},
                error: true,
            },
        }),

        [receiveGroups]: (state, { payload }) => ({
            ...state,
            groups: payload,
        }),
        [receiveSegments]: (state, { payload }) => ({
            ...state,
            segments: payload,
        }),
        [receiveSegmentsDone]: (state) => ({
            ...state,
            segmentsInfo: buildSegmentsInfo(state.groups, state.attributes.value),
            loaded: true,
        }),
        [requestSegmentsAttributes]: (state) => ({
            ...state,
            attributes: {
                ...state.attributes,
                loading: true,
                error: false,
            },
        }),
        [receiveSegmentsAttributes]: (state, { payload }) => ({
            ...state,
            attributes: {
                value: payload,
                loading: false,
                error: false,
            },
            // FIXME this is a hacky way, should be in a single place
            segmentsInfo: buildSegmentsInfo(state.groups, payload),
        }),
        [failSegmentsAttributes]: (state) => ({
            ...state,
            attributes: {
                ...state.attributes,
                loading: false,
                error: true,
            },
        }),

        [receiveExportsToSegments]: (state, { payload }) => ({
            ...state,
            exportsToSegments: payload,
        }),

        [receiveRule]: (state, { payload }) => ({ ...state, rule: payload }),
        [startProcessingData]: (state) => ({
            ...state,
            loaded: false,
            error: "",
        }),
        [finishProcessingData]: (state) => ({ ...state, loaded: true }),
        [failProcessingData]: (state, { payload }) => ({
            ...state,
            loaded: true,
            error: payload,
        }),
        [showSegmentStatsModal]: (state, { payload }) => ({
            ...state,
            visibleSegmentStatsModal: true,
            export: payload,
        }),
        [hideSegmentStatsModal]: (state) => ({
            ...state,
            visibleSegmentStatsModal: false,
            export: undefined,
        }),
        [showRuleRevisionEstimateStatsModal]: (state, { payload }) => ({
            ...state,
            visibleRuleRevisionEstimateStatsModal: true,
            export: payload,
        }),
        [hideRuleRevisionEstimateStatsModal]: (state) => ({
            ...state,
            visibleRuleRevisionEstimateStatsModal: false,
            export: undefined,
        }),
        [showRuleEstimateStatsModal]: (state, { payload }) => ({
            ...state,
            visibleRuleEstimateStatsModal: true,
            export: payload,
        }),
        [hideRuleEstimateStatsModal]: (state) => ({
            ...state,
            visibleRuleEstimateStatsModal: false,
            export: undefined,
        }),
        [showRuleModal]: (state, { payload }) => ({
            ...state,
            visibleRuleModal: true,
            ruleId: payload,
        }),
        [refreshRule]: (state, { payload }) => ({ ...state, rule: payload }),
        [hideRuleModal]: (state) => ({
            ...state,
            visibleRuleModal: false,
            ruleId: undefined,
            rule: {},
        }),
        [resetSearch]: (state) => ({
            ...state,
            segmentsInfo: buildSearchedTree(state.segmentsInfo, [], []),
            nothingFound: false,
            triggerRerenderSegments: !state.triggerRerenderSegments,
        }),
        [handleSearch]: (state, { payload }) => ({
            ...state,
            segmentsInfo: buildSearchedTree(state.segmentsInfo, state.matchedSearchItems.value, payload),
            triggerRerenderSegments: !state.triggerRerenderSegments,
        }),

        [requestMatchSearchItems]: (state) => ({
            ...state,
            matchedSearchItems: {
                ...state.matchedSearchItems,
                value: [],
                loading: true,
                error: false,
            },
        }),
        [receiveMatchSearchItems]: (state, { payload }) => ({
            ...state,
            matchedSearchItems: {
                value: payload,
                loading: false,
                error: false,
            },
            nothingFound: isEmpty(payload),
        }),
        [failMatchSearchItems]: (state) => ({
            ...state,
            matchedSearchItems: {
                value: [],
                loading: false,
                error: false,
            },
        }),

        [updateSegmentToMove]: (state, { payload }) => ({
            ...state,
            segmentToMove: payload,
        }),
        [handleEditButtonClick]: (state) => ({
            ...state,
            isActiveEditButton: !state.isActiveEditButton,
            segmentToMove: undefined,
        }),

        [setExpressionsModalVisibility]: (state, { payload }) => ({
            ...state,
            modals: {
                ...state.modals,
                expressions: payload,
            },
        }),

        [setLalModalVisibility]: (state, { payload }) => ({
            ...state,
            modals: {
                ...state.modals,
                lal: payload,
            },
        }),

        [setCreateSegmentModalVisibility]: (state, { payload }) => ({
            ...state,
            modals: {
                ...state.modals,
                createSegment: payload,
            },
        }),

        [setAudienceSegmentFeaturesModalVisibility]: (state, { payload }) => ({
            ...state,
            modals: {
                ...state.modals,
                audiencesSegmentFeatures: payload,
            },
        }),

        [openExportTagsModal]: (state) => ({
            ...state,
            modals: {
                ...state.modals,
                exportTags: true,
            },
        }),
        [closeExportTagsModal]: (state) => ({
            ...state,
            modals: {
                ...state.modals,
                exportTags: false,
            },
        }),
        [setTankerModalVisibility]: (state, { payload }) => ({
            ...state,
            modals: { ...state.modals, tanker: payload },
        }),

        [setActiveSegmentExportId]: (state, { payload }) => ({
            ...state,
            exportSegmentId: payload,
        }),
        [setActiveSegmentExportTags]: (state, { payload }) => ({
            ...state,
            exportSegmentTags: payload,
        }),

        [requestStoreExpressions]: (state, { payload }) => ({
            ...state,
            storedExpressions: {
                exportId: payload,
                loading: true,
                value: [],
                error: false,
            },
        }),
        [receiveStoreExpressions]: (state, { payload }) => ({
            ...state,
            storedExpressions: {
                ...state.storedExpressions,
                loading: false,
                value: payload.expressions,
            },
        }),
        [failStoreExpressions]: (state) => ({
            ...state,
            storedExpressions: {
                ...state.storedExpressions,
                loading: false,
                error: true,
            },
        }),
        [requestStoreLal]: (state, { payload }) => ({
            ...state,
            storedLal: {
                exportId: payload,
                loading: true,
                value: [],
                error: false,
            },
        }),
        [receiveStoreLal]: (state, { payload }) => ({
            ...state,
            storedLal: {
                ...state.storedLal,
                loading: false,
                value: payload.lal,
            },
        }),
        [failStoreLal]: (state) => ({
            ...state,
            storedLal: {
                ...state.storedLal,
                loading: false,
                error: true,
            },
        }),
        [requestSegmentExport]: (state, { payload }) => ({
            ...state,
            editableExport: {
                exportId: payload,
                value: {},
                loading: true,
                error: false,
            },
        }),
        [receiveSegmentExport]: (state, { payload }) => ({
            ...state,
            editableExport: {
                ...state.editableExport,
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failSegmentExport]: (state) => ({
            ...state,
            editableExport: {
                ...state.editableExport,
                loading: false,
                value: {},
                error: true,
            },
        }),

        [requestDeleteExpressions]: (state, { payload }) => ({
            ...state,
            editableExport: {
                exportId: payload,
                value: {},
                loading: true,
                error: false,
            },
        }),
        [receiveDeleteExpressions]: (state, { payload }) => ({
            ...state,
            editableExport: {
                ...state.editableExport,
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failDeleteExpressions]: (state) => ({
            ...state,
            editableExport: {
                ...state.editableExport,
                loading: false,
                value: {},
                error: true,
            },
        }),

        [requestDeleteLal]: (state, { payload }) => ({
            ...state,
            editableExport: {
                exportId: payload,
                value: {},
                loading: true,
                error: false,
            },
        }),
        [receiveDeleteLal]: (state, { payload }) => ({
            ...state,
            editableExport: {
                ...state.editableExport,
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failDeleteLal]: (state) => ({
            ...state,
            editableExport: {
                ...state.editableExport,
                loading: false,
                value: {},
                error: true,
            },
        }),

        [requestExportInfo]: (state, { payload }) => ({
            ...state,
            exportInfo: {
                exportId: payload,
                loading: true,
                value: null,
                error: false,
            },
        }),
        [receiveExportInfo]: (state, { payload }) => ({
            ...state,
            exportInfo: {
                ...state.exportInfo,
                loading: false,
                value: payload,
            },
        }),
        [failExportInfo]: (state) => ({
            ...state,
            exportInfo: {
                ...state.exportInfo,
                value: null,
                loading: false,
                error: true,
            },
        }),

        [requestSegmentByExportId]: (state) => ({
            ...state,
            segmentByExportId: {
                value: {},
                loading: true,
                error: false,
            },
        }),
        [receiveSegmentByExportId]: (state, { payload }) => ({
            ...state,
            segmentByExportId: {
                value: payload,
                loading: false,
                error: false,
            },
        }),
        [failSegmentByExportId]: (state) => ({
            ...state,
            segmentByExportId: {
                value: {},
                loading: false,
                error: true,
            },
        }),

        [showExportTooltip]: (state, { payload }) => ({
            ...state,
            exportTooltip: {
                activeIndex: payload,
                visible: true,
            },
        }),
        [hideExportTooltip]: (state) => ({
            ...state,
            exportTooltip: {
                activeIndex: null,
                visible: false,
            },
        }),

        [requestSegmentStats]: (state) => ({
            ...state,
            stats: {
                loading: true,
                value: {},
                error: false,
            },
        }),
        [receiveSegmentStats]: (state, { payload }) => ({
            ...state,
            stats: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failSegmentStats]: (state) => ({
            ...state,
            stats: {
                loading: false,
                value: {},
                error: true,
            },
        }),

        [setRequestApprovalVisibility]: (state, { payload }) => ({
            ...state,
            requestApprovalVisible: payload,
        }),
        [requestRequestConditionApproval]: (state) => ({
            ...state,
            conditionApprovalRequest: {
                loading: true,
                error: null,
                value: null,
            },
        }),
        [receiveRequestConditionApproval]: (state, { payload }) => ({
            ...state,
            conditionApprovalRequest: {
                loading: false,
                error: null,
                value: payload,
            },
        }),
        [failRequestConditionApproval]: (state) => ({
            ...state,
            conditionApprovalRequest: {
                loading: false,
                error: true,
                value: null,
            },
        }),
        [resetRequestConditionApproval]: (state) => ({
            ...state,
            conditionApprovalRequest: {
                loading: false,
                error: false,
                value: null,
            },
        }),
        [setActiveCondition]: (state, { payload }) => ({
            ...state,
            activeCondition: payload,
        }),

        [requestSegmentsData]: (state) => ({
            ...state,
            attributes: {
                loading: true,
                value: [],
                error: false,
            },
        }),
        [receiveSegmentsData]: (state, { payload }) => ({
            ...state,
            attributes: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failSegmentsData]: (state) => ({
            ...state,
            attributes: {
                loading: false,
                value: [],
                error: true,
            },
        }),

        [requestMatchSegmentConditions]: (state) => ({
            ...state,
            matchedSegments: {
                loading: true,
                value: [],
                error: false,
            },
            showDeleted: false,
        }),
        [receiveMatchSegmentConditions]: (state, { payload }) => ({
            ...state,
            matchedSegments: {
                loading: false,
                value: payload.matched,
                error: false,
            },
            showDeleted: payload.showDeleted,
        }),
        [failMatchSegmentCondition]: (state) => ({
            ...state,
            matchedSegments: {
                loading: false,
                value: [],
                error: true,
            },
            showDeleted: false,
        }),
        [resetMatchSegmentConditions]: (state) => ({
            ...state,
            matchedSegments: {
                loading: false,
                value: [],
                error: false,
            },
            showDeleted: false,
        }),

        [requestRuleRevisionEstimateStats]: (state) => ({
            ...state,
            ruleRevisionStats: {
                loading: true,
                value: {},
                error: false,
            },
        }),
        [receiveRuleRevisionEstimateStats]: (state, { payload }) => ({
            ...state,
            ruleRevisionStats: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failRuleRevisionEstimateStats]: (state) => ({
            ...state,
            ruleRevisionStats: {
                loading: false,
                value: {},
                error: true,
            },
        }),
        [requestRuleRevisionEstimateCoverage]: (state) => ({
            ...state,
            ruleRevisionCoverage: {
                loading: true,
                value: 0,
                error: false,
            },
        }),
        [receiveRuleRevisionEstimateCoverage]: (state, { payload }) => ({
            ...state,
            ruleRevisionCoverage: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failRuleRevisionEstimateCoverage]: (state) => ({
            ...state,
            ruleRevisionCoverage: {
                loading: false,
                value: 0,
                error: true,
            },
        }),
        [requestRuleEstimateStats]: (state) => ({
            ...state,
            ruleStats: {
                loading: true,
                value: {},
                error: false,
            },
        }),
        [receiveRuleEstimateStats]: (state, { payload }) => ({
            ...state,
            ruleStats: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failRuleEstimateStats]: (state) => ({
            ...state,
            ruleStats: {
                loading: false,
                value: {},
                error: true,
            },
        }),
        [requestRuleEstimateCoverage]: (state) => ({
            ...state,
            ruleCoverage: {
                loading: true,
                value: 0,
                error: false,
            },
        }),
        [receiveRuleEstimateCoverage]: (state, { payload }) => ({
            ...state,
            ruleCoverage: {
                loading: false,
                value: payload,
                error: false,
            },
        }),
        [failRuleEstimateCoverage]: (state) => ({
            ...state,
            ruleCoverage: {
                loading: false,
                value: 0,
                error: true,
            },
        }),
    },
    {
        loaded: false,
        modals: {},
        segmentsInfo: {},
        activeSegmentInfo: {},
        visibleSegmentStatsModal: false,
        visibleRuleModal: false,
        visibleExpressionsModal: false,
        visibleLalModal: false,
        activeExportId: null,
        isActiveEditButton: false,
        searchItems: [],
        error: "",
        audienceSegmentsToGrants: {},
        createdGrants: {},
        deletedGrants: {},
        storedExpressions: {},
        storedLal: {},
        editableExport: {},
        exportTooltip: {
            visible: false,
            activeExportId: null,
        },
        stats: {
            loading: false,
            value: {},
            error: false,
        },
        ruleRevisionStats: {
            loading: false,
            value: {},
            error: false,
        },
        ruleRevisionCoverage: {
            loading: false,
            value: 0,
            error: false,
        },
        visibleRuleRevisionEstimateStatsModal: false,
        ruleStats: {
            loading: false,
            value: {},
            error: false,
        },
        ruleCoverage: {
            loading: false,
            value: 0,
            error: false,
        },
        visibleRuleEstimateStatsModal: false,
        conditionApprovalRequest: {},
        requestApprovalVisible: false,
        notLocalizedSegment: {},
        updatedNameAndDescription: {},
        matchedSegments: {
            value: [],
            loading: false,
            error: false,
        },
        matchedSearchItems: {
            value: [],
            loading: false,
            error: false,
        },
        nothingFound: false,
        segmentByExportId: {
            value: {},
            loading: true,
            error: false,
        },
        activeCondition: {},
        showDeleted: false,
    }
);

function buildSegmentsInfo(groups, segments) {
    let segmentsInfo = _fromPairs(
        _map(_concat(groups, segments), (each) => [
            each.id,
            {
                ...each,
                children: [],
                isSearched: false,
                isVisible: !isDeleted(each),
                isDeleted: isDeleted(each),
                hasSearchedParent: false,
                hasSearchedChild: false,
            },
        ])
    );
    _forEach(segmentsInfo, (each) => {
        if (each.id !== "root") {
            segmentsInfo[each.parentId].children.push(each);
        }
    });

    return segmentsInfo;
}

function buildSearchedTree(segmentsInfo, matchedSegments, searchItems) {
    let hasSearchedParent = isEmpty(searchItems); // Makes all children visible
    processSearch(segmentsInfo["root"], new Set(matchedSegments.map((segment) => segment.id)), hasSearchedParent);

    return segmentsInfo;
}

function processSearch(segment, matchedSegments, hasSearchedParent) {
    segment.isSearched = matchedSegments.has(segment.id);
    segment.hasSearchedParent = hasSearchedParent;
    segment.hasSearchedChild = hasSearchedChild(segment, matchedSegments, hasSearchedParent);
    segment.isVisible = isVisible(segment);
    segment.isDeleted = isDeleted(segment);
}

function isVisible(segment) {
    return  segment.isSearched || segment.hasSearchedParent || segment.hasSearchedChild;
}

function hasSearchedChild(segment, matchedSegments, hasSearchedParent) {
    _forEach(segment.children, (each) => processSearch(each, matchedSegments, segment.isSearched || hasSearchedParent));
    return _some(segment.children, (each) => (each.isSearched || each.hasSearchedChild));
}

export function isDeleted(segment) {
    return segment.state ? segment.state === "DELETED" : false;
}
