import React, { useState } from "react";
import FontAwesome from "react-fontawesome";
import { Button } from "@lib/components/lego";
import { difference as _difference } from "lodash";
import { useTranslation } from "react-i18next";

import "./style.scss";

import AddConditionPopup from "./AddConditionPopup";

const SOURCES = [
    "PUBLIC_WORDS",
    "PUBLIC_SITES",
    "PRECALCULATED_TABLES",
    "SEARCH_RESULTS_HOSTS",
    "APPS",
    "CATALOGIA",
    "METRICA_COUNTERS_AND_GOALS",
    "MUSIC_LIKES",
    "EFIR_CHANNELS",
    "EFIR_PROGRAMS",
    "WORDS",
    "SITES",
];

const AddConditionButton = (props) => {
    const { sources, ruleId, onSourceChange } = props;

    const { t } = useTranslation("segments");

    const [isCreationMode, setCreationMode] = useState(false);

    const switchCreationMode = () => {
        setCreationMode(!isCreationMode);
    };

    const getUncreatedSources = () => {
        return _difference(SOURCES, sources);
    };

    const uncreatedSources = getUncreatedSources();
    const hasUncreatedSources = uncreatedSources.length > 0;
    const hasSources = sources.length > 0;

    return (
        <div className="AddConditionButton">
            <Button
                view="clear"
                key="add-condition-button"
                theme={hasSources ? "raised" : "action"}
                size="s"
                disabled={!hasUncreatedSources}
                checked={isCreationMode}
                onClick={switchCreationMode}
            >
                <FontAwesome name="plus" />
                <span> {!hasSources && t("rule.newCondition")}</span>
            </Button>

            <AddConditionPopup
                key="add-condition-popup"
                visible={hasUncreatedSources && isCreationMode}
                ruleId={ruleId}
                sources={uncreatedSources}
                onSourceChange={onSourceChange}
                onOutsideClick={switchCreationMode}
            />
        </div>
    );
};

export default AddConditionButton;
