import React, { useEffect, useState } from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import { Button, Select } from "@lib/components/lego";
import { putRuleCondition } from "../actions";
import { getApiState, getLanguageState } from "../../selectors";

import "./style.scss";

const AddConditionPopup = connect((state) => ({
    api: getApiState(state),
    lang: getLanguageState(state),
}))((props) => {
    const { visible, sources, api, dispatch, ruleId, onSourceChange, onOutsideClick } = props;

    const [currentSource, setCurrentSource] = useState(undefined);

    const { t, i18n } = useTranslation(["condition", "common"]);
    const lang = i18n.language;

    const initializeSource = () => {
        setCurrentSource(sources[0]);
    };

    useEffect(() => {
        initializeSource();
    }, []);

    useEffect(() => {
        initializeSource();
    }, [visible]);

    const putCondition = () => dispatch(putRuleCondition(api, lang, ruleId, currentSource, [], onSourceChange));

    const createRule = () => {
        putCondition().then(() => {
            onOutsideClick();
        });
    };

    return (
        <div className={"ConditionTooltip" + (visible ? "" : "-hidden")}>
            <div className="ConditionTooltip-items">
                <span className="ConditionTooltip-item">
                    <Select
                        view="default"
                        size="s"
                        width="max"
                        value={currentSource}
                        onChange={(event) => setCurrentSource(event.target.value)}
                        options={sources.map((each) => ({
                            value: each,
                            content: t("conditionSelector." + [each]),
                        }))}
                    />
                </span>
                <span className="ConditionTooltip-item">
                    <Button
                        key="add-button"
                        view="clear"
                        theme="action"
                        size="s"
                        title={"Add new condition"}
                        onClick={createRule}
                    >
                        <FontAwesome name={"plus"} />
                    </Button>
                </span>
                <span className="ConditionTooltip-item">
                    <Button
                        key="done-button"
                        view="clear"
                        theme="pseudo"
                        size="s"
                        title={t("common:actions.close")}
                        onClick={onOutsideClick}
                    >
                        {t("common:actions.close")}
                    </Button>
                </span>
            </div>
        </div>
    );
});

export default AddConditionPopup;
