import React from "react";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import { Button } from "@lib/components/lego";

import ActionButton from "../utils/ActionButton";
import FinishChangesButtons from "../utils/FinishChangesButtons";
import { connect } from "react-redux";
import { getRulePropertiesState } from "./selectors";

const ConditionCardToolsBar = (props) => {
    const {
        editing,
        onEditClick,
        onDeleteCondition,
        format,
        onFormatChange,
        needUserApprove,
        onApprove,
        onAcceptEditing,
        onRejectEditing,
        canEdit,
    } = props;

    const { t } = useTranslation("segments");

    const renderRightPanel = () => {
        return (
            <span>
                {!editing && <ActionButton action="edit" view="clear" theme="raised" size="s" onClick={onEditClick} />}
                <ActionButton action="delete" view="clear" theme="raised" size="s" onClick={onDeleteCondition} />
            </span>
        );
    };

    return (
        <span className="rule-condition-edit-tools-bar">
            <span>
                <ConditionInfoFormatSelector selectedFormat={format} onChange={onFormatChange} />
            </span>
            <span className="rule-condition-edit-tools-bar-right">
                {needUserApprove && (
                    <ActionButton
                        className="approve-button"
                        action="approve"
                        view="action"
                        theme="raised"
                        size="s"
                        text={t("rule.approve")}
                        onClick={onApprove}
                    />
                )}

                {editing && <FinishChangesButtons onAccept={onAcceptEditing} onReject={onRejectEditing} />}

                {canEdit && renderRightPanel()}
            </span>
        </span>
    );
};

const ConditionInfoFormatSelector = connect((state) => ({
    source: getRulePropertiesState(state).source,
}))((props) => {
    const { selectedFormat, onChange, source } = props;

    const disabled = source && source === "PRECALCULATED_TABLES";

    return (
        <span>
            <Button
                view="clear"
                theme="raised"
                size="s"
                pin="round-brick"
                checked={selectedFormat === "blocks"}
                title="Blocks"
                onClick={() => onChange("blocks")}
                disabled={disabled}
            >
                <FontAwesome name="align-justify" />
            </Button>
            <Button
                view="clear"
                theme="raised"
                size="s"
                pin="brick-round"
                checked={selectedFormat === "text"}
                title="Text"
                onClick={() => onChange("text")}
                disabled={disabled}
            >
                <FontAwesome name="bold" />
            </Button>
        </span>
    );
});

export default ConditionCardToolsBar;
