import SimpleDate from "../../utils/SimpleDate";
import FontAwesome from "react-fontawesome";
import { Button, Spin, TooltipStateful } from "@lib/components/lego";
import React from "react";

const BUTTON_SIZE = "s";
const BUTTON_VIEW = "clear";
const BUTTON_THEME = "link";

const Coverage = (props) => {
    const { loading, failed, value, lang, hasEstimateStats, handleShowAndRequestStats, setTooltipVisibility, t } =
        props;

    return (
        <span className="Coverage">
            {loading ? (
                <Spin progress size="xxs" view="default" />
            ) : (
                <span>
                    <span>
                        {hasEstimateStats
                            ? failed
                                ? t("rule.estimate.missing")
                                : value.IsReady
                                ? value.Coverage
                                : t("rule.estimate.updating")
                            : t("segments:rule.estimate.notSupported")}
                    </span>
                    {hasEstimateStats && !failed && (
                        <SimpleDate className="timestamp" lang={lang} value={value.Timestamp} />
                    )}
                </span>
            )}
            {hasEstimateStats && (
                <TooltipStateful
                    size="s"
                    view="default"
                    content={t("segments:rule.estimate.showRuleConditionStats")}
                    hasTail
                >
                    <Button
                        view={BUTTON_VIEW}
                        theme={BUTTON_THEME}
                        size={BUTTON_SIZE}
                        onClick={handleShowAndRequestStats}
                        onMouseOver={() => setTooltipVisibility(true)}
                        onMouseLeave={() => setTooltipVisibility(false)}
                    >
                        <FontAwesome name="pie-chart" />
                    </Button>
                </TooltipStateful>
            )}
        </span>
    );
};

export default Coverage;
