import React, { useEffect, useState } from "react";
import { useTranslation } from "react-i18next";

import { fetchRuleEstimateCoverage, fetchRuleEstimateStats, showRuleEstimateStatsModal } from "../actions";
import { connect } from "react-redux";
import { getRuleState, getRuleEstimateCoverageState } from "../selectors";
import { isEmpty, isNil } from "lodash";
import Coverage from "./Coverage";
import { getApiState } from "../../selectors";

const RuleInfoCoverage = connect((state) => ({
    api: getApiState(state),
    rule: getRuleState(state),
    value: getRuleEstimateCoverageState(state).value,
    loading: getRuleEstimateCoverageState(state).loading,
    failed: getRuleEstimateCoverageState(state).error,
}))((props) => {
    const { rule, api, dispatch, failed, loading, value } = props;

    const { t, i18n } = useTranslation(["segments"]);
    const lang = i18n.language;

    const initialize = () => {
        if (hasEstimateStats(rule) && !isNil(rule.id)) {
            dispatch(fetchRuleEstimateCoverage(api, rule.id, lang));
        }
    };

    useEffect(() => {
        initialize();
    }, [rule]);

    const [tooltipVisible, setTooltipVisibility] = useState(false);

    const conditionHasEstimateStats = hasEstimateStats(rule);

    const handleShowAndRequestStats = () => {
        if (!isEmpty(rule) && !isNil(rule.id)) {
            dispatch(fetchRuleEstimateStats(api, rule.id, lang));
            dispatch(showRuleEstimateStatsModal(rule));
        }
    };

    return (
        <Coverage
            loading={loading}
            failed={failed}
            value={value}
            lang={lang}
            hasEstimateStats={conditionHasEstimateStats}
            handleShowAndRequestStats={handleShowAndRequestStats}
            setTooltipVisibility={setTooltipVisibility}
            t={t}
        />
    );
});

function hasEstimateStats(rule) {
    return !isEmpty(rule) && !isNil(rule.id);
}

export default RuleInfoCoverage;
