import { connect, useDispatch } from "react-redux";
import { getActiveConditionState, getRuleState } from "../selectors";
import React, { useState } from "react";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import { getApiState } from "../../selectors";
import { updateRuleEstimates } from "../actions";
import { Button, TooltipStateful } from "@lib/components/lego";

const UpdateEstimateStatsButton = connect((state) => ({
    api: getApiState(state),
    rule: getRuleState(state),
    activeCondition: getActiveConditionState(state),
}))((props) => {
    const dispatch = useDispatch();

    const [tooltipVisible, setTooltipVisibility] = useState(false);

    const { api, rule, activeCondition } = props;
    const { t, i18n } = useTranslation("segments");

    const lang = i18n.language;

    const handleUpdateRuleEstimates = () => {
        dispatch(updateRuleEstimates(api, rule.id, activeCondition.revision, lang));
    };

    return (
        <TooltipStateful size="s" view="default" content={t("rule.estimate.update")} hasTail>
            <Button
                view="clear"
                theme="link"
                size="s"
                onClick={handleUpdateRuleEstimates}
                onMouseOver={() => setTooltipVisibility(true)}
                onMouseLeave={() => setTooltipVisibility(false)}
            >
                <FontAwesome name="undo" />
            </Button>
        </TooltipStateful>
    );
});

export default UpdateEstimateStatsButton;
