import React from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";

import Loading from "@lib/components/loading";
import Failable from "src/utils/Failable";
import RuleInfo from "src/segments/rule/RuleInfo";
import Conditions from "src/segments/rule/Conditions";
import {
    getActiveSegmentInfoState,
    getApiState,
    getErrorState,
    getRuleState,
    getVisibleRuleModalState,
} from "src/selectors";
import { allowedToEditSegment } from "../../utils/roles";
import { getAccessState } from "../../selectors";

import "./style.scss";

const Rule = connect((state) => ({
    api: getApiState(state),
    visible: getVisibleRuleModalState(state),
    rule: getRuleState(state),
    error: getErrorState(state),
    isAdmin: getAccessState(state).Admin,
    segment: getActiveSegmentInfoState(state).value,
}))((props) => {
    const { rule, exportId, error, isAdmin, segment } = props;

    const canEdit = isAdmin || allowedToEditSegment(segment);

    return (
        <Failable failed={error} errorMessage={error.message}>
            <Loading loaded={rule}>
                {rule && (
                    <div>
                        {!isEmpty(rule) && <RuleInfo rule={rule} exportId={exportId} canEdit={canEdit} />}
                        {!isEmpty(rule) && <Conditions canEdit={canEdit} />}
                    </div>
                )}
            </Loading>
        </Failable>
    );
});

export default Rule;
