import React from "react";
import { connect } from "react-redux";

import SegmentItem from "../tree/SegmentItem";
import { isEmpty } from "lodash";
import { getMatchedSegmentsState } from "../selectors";

import "./style.scss";

const SegmentsList = connect((state) => ({
    segments: getMatchedSegmentsState(state),
}))((props) => {
    const { segments } = props;

    return (
        <div className="SegmentsList">
            {segments.value.map((segment) => {
                return (
                    <SegmentItem
                        key={"segment_line-" + segment.id}
                        segment={segment}
                        level={0}
                        hasChildren={!isEmpty(segment.children)}
                        collapsed={false}
                        handleArrowClick={null}
                    />
                );
            })}
        </div>
    );
});

export default SegmentsList;
