import { createSelector } from "reselect";
import qs from "query-string";
import { get as _get } from "lodash";

const getLoaded = (state) => state.segments.loaded;
export const getLoadedState = createSelector(getLoaded, (data) => data);

const getError = (state) => state.segments.error;
export const getErrorState = createSelector(getError, (data) => data);

const getNotLocalizedSegment = (state) => state.segments.notLocalizedSegment;
export const getNotLocalizedSegmentState = createSelector(getNotLocalizedSegment, (segment) => segment);

const getUpdatedNameAndDescription = (state) => state.segments.updatedNameAndDescription;
export const getUpdatedNameAndDescriptionState = createSelector(
    getUpdatedNameAndDescription,
    (properties) => properties
);

const getRequestApproval = (state) => state.segments.requestApprovalVisible;
export const getRequestApprovalVisibilityState = createSelector(getRequestApproval, (visible) => visible);

const getSegmentsModals = (state) => state.segments.modals;
export const getSegmentsModalsState = createSelector(getSegmentsModals, (data) => data);

const getGroups = (state) => state.segments.groups;
export const getGroupsState = createSelector(getGroups, (data) => data);

const getRule = (state) => state.segments.rule;
export const getRuleState = createSelector(getRule, (data) => data);

const getActiveExportId = (state) => state.segments.activeExportId;
export const getActiveExportIdState = createSelector(getActiveExportId, (data) => data);

const getStoredExportExpressions = (state) => state.segments.expressions;
export const getStoredExportExpressionsState = createSelector(getStoredExportExpressions, (data) => data);

const getEditableExport = (state) => state.segments.editableExport;
export const getEditableExportState = createSelector(getEditableExport, (data) => data);

const getExportTooltipVisibility = (state) => state.segments.exportTooltip;
export const getExportTooltipVisibilityState = createSelector(getExportTooltipVisibility, (data) => data);

const getExportInfo = (state) => state.segments.exportInfo;
export const getExportInfoState = createSelector(getExportInfo, (data) => data);

const getSegmentByExportId = (state) => state.segments.segmentByExportId;
export const getSegmentByExportIdState = createSelector(getSegmentByExportId, (data) => data);

const getSegmentStats = (state) => state.segments.stats;
export const getSegmentStatsState = createSelector(getSegmentStats, (data) => data);

const getActiveIds = (state) => {
    let location = state.router.location;
    let group = qs.parse(location.search).group || "root";
    let segment = qs.parse(location.search).segment || group;
    let segmentExport = qs.parse(location.search).export || undefined;
    return { group: group, segment: segment, export: segmentExport };
};
export const getActiveIdsState = createSelector(getActiveIds, (data) => data);

const getLocationSearch = (state) => {
    return state.router.location.search;
};
export const getLocationSearchState = createSelector(getLocationSearch, (data) => data);

const getQuery = (state) => {
    return qs.parse(state.router.location.search).query;
};
export const getQueryState = createSelector(getQuery, (data) => data);

const getSegmentsInfo = (state) => state.segments.segmentsInfo;
export const getSegmentsInfoState = createSelector([getSegmentsInfo], (segments) => segments);
export const getActiveSegmentAttributesState = createSelector([getActiveIds, getSegmentsInfo], (active, segments) => {
    if (segments) {
        return _get(segments, active.segment);
    } else {
        return null;
    }
});

const getTriggerRerenderSegments = (state) => state.segments.triggerRerenderSegments;
export const getTriggerRerenderSegmentsState = createSelector(getTriggerRerenderSegments, (data) => data);

const getMatchedSegments = (state) => state.segments.matchedSegments;
export const getMatchedSegmentsState = createSelector([getMatchedSegments], (data) => data);

const getMatchedSearchItemsSegments = (state) => state.segments.matchedSearchItems;
export const getMatchedSearchItemsSegmentsState = createSelector(getMatchedSearchItemsSegments, (data) => data);

const getNothingFound = (state) => state.segments.nothingFound;
export const getNothingFoundState = createSelector(getNothingFound, (data) => data);

const getSegmentsAttributes = (state) => state.segments.attributes;
export const getSegmentsAttributesState = createSelector([getSegmentsAttributes], (data) => data);

const getActiveSegmentInfo = (state) => state.segments.activeSegmentInfo;
export const getActiveSegmentInfoState = createSelector([getActiveSegmentInfo], (segment) => segment);

const getVisibleSegmentStatsModal = (state) => state.segments.visibleSegmentStatsModal;
export const getVisibleSegmentStatsModalState = createSelector(getVisibleSegmentStatsModal, (data) => data);

const getVisibleRuleModal = (state) => state.segments.visibleRuleModal;
export const getVisibleRuleModalState = createSelector(getVisibleRuleModal, (data) => data);

const getActiveSegmentExport = (state) => state.segments.export;
export const getActiveSegmentExportState = createSelector(getActiveSegmentExport, (data) => data);

const getActiveRuleId = (state) => state.segments.ruleId;
export const getActiveRuleIdState = createSelector(getActiveRuleId, (data) => data);

export const getSegmentsTreeRootState = createSelector(getSegmentsInfo, (segmentsInfo) => segmentsInfo["root"]);

export const getSegmentsTreeActiveRootState = createSelector(
    [getSegmentsInfo, getActiveIds],
    (segmentsInfo, activeIds) => segmentsInfo[activeIds.group]
);

const getSegmentToMove = (state) => state.segments.segmentToMove;
export const getSegmentToMoveState = createSelector(getSegmentToMove, (data) => data);

const getEditButton = (state) => state.segments.isActiveEditButton;
export const getEditButtonState = createSelector(getEditButton, (data) => data);

const getConditionApproval = (state) => state.segments.conditionApprovalRequest;
export const getConditionApprovalState = createSelector(getConditionApproval, (data) => data);

const getActiveCondition = (state) => state.segments.activeCondition || {};
export const getActiveConditionState = createSelector(getActiveCondition, (data) => data);

const getRuleRevisionEstimateStats = (state) => state.segments.ruleRevisionStats;
export const getRuleRevisionEstimateStatsState = createSelector(getRuleRevisionEstimateStats, (data) => data);

const getRuleRevisionEstimateCoverage = (state) => state.segments.ruleRevisionCoverage;
export const getRuleRevisionEstimateCoverageState = createSelector(getRuleRevisionEstimateCoverage, (data) => data);

const getVisibleRuleRevisionEstimateStatsModal = (state) => state.segments.visibleRuleRevisionEstimateStatsModal;
export const getVisibleRuleRevisionEstimateStatsModalState = createSelector(
    getVisibleRuleRevisionEstimateStatsModal,
    (data) => data
);

const getRuleEstimateStats = (state) => state.segments.ruleStats;
export const getRuleEstimateStatsState = createSelector(getRuleEstimateStats, (data) => data);

const getRuleEstimateCoverage = (state) => state.segments.ruleCoverage;
export const getRuleEstimateCoverageState = createSelector(getRuleEstimateCoverage, (data) => data);

const getVisibleRuleEstimateStatsModal = (state) => state.segments.visibleRuleEstimateStatsModal;
export const getVisibleRuleEstimateStatsModalState = createSelector(getVisibleRuleEstimateStatsModal, (data) => data);

const getSegmentGrants = (state) => state.segments.audienceSegmentsToGrants;
export const getSegmentGrantsState = createSelector(getSegmentGrants, (data) => data);

const getShowDeleted = (state) => state.segments.showDeleted;
export const getShowDeletedState = createSelector(getShowDeleted, (data) => data);
