import React from "react";
import { connect } from "react-redux";

import { getAccessState, getEditButtonState } from "../../selectors";
import { handleEditButtonClick } from "../actions";
import "./EditTreeButton.scss";
import ActionButton from "../utils/ActionButton";
import { useTranslation } from "react-i18next";

const EditTreeButton = connect((state) => ({
    visible: getAccessState(state).Admin,
    checked: getEditButtonState(state),
}))((props) => {
    const { visible, checked, dispatch } = props;

    const { t } = useTranslation("segments");

    const onClick = () => dispatch(handleEditButtonClick());

    const text = checked ? t("tree.finishEdition") : "";

    return (
        visible && (
            <ActionButton
                size="s"
                action="edit"
                view="pseudo"
                checked={checked}
                text={text}
                title={t("tree.edit")}
                onClick={onClick}
            />
        )
    );
});

export default EditTreeButton;
