import React from "react";
import { connect } from "react-redux";
import { isEmpty, isUndefined, some as _some } from "lodash";
import { getApiState, getEditButtonState, getSegmentToMoveState } from "../../selectors";
import { handleSegmentMove, updateSegmentToMove } from "../actions";
import "./MoveSegmentLabel.scss";
import { useTranslation } from "react-i18next";

const MoveSegmentLabel = connect((state) => ({
    api: getApiState(state),
    active: getEditButtonState(state),
    segmentToMove: getSegmentToMoveState(state),
}))((props) => {
    const { api, active, segmentToMove, segment, dispatch } = props;

    const { t, i18n } = useTranslation("segments");
    const lang = i18n.language;

    const setSegmentToMove = (moveFrom) => dispatch(updateSegmentToMove(moveFrom));
    const moveSegment = (moveFrom, moveTo) => dispatch(handleSegmentMove(api, lang, moveFrom, moveTo));

    const handleClick = () => {
        if (isUndefined(segmentToMove)) {
            setSegmentToMove(segment);
        } else {
            moveSegment(segmentToMove, segment);
        }
    };

    const isChildOfSegment = (checkedSegment) => {
        if (isEmpty(checkedSegment.children)) {
            return false;
        } else {
            return _some(checkedSegment.children, (child) => child.id === segment.id || isChildOfSegment(child));
        }
    };

    const isRootSegmentToMove = isUndefined(segmentToMove) && segment.id === "root";
    const isEqualToSegmentToMove = !isUndefined(segmentToMove) && segment.id === segmentToMove.id;
    const isChildOfSegmentToMove = !isUndefined(segmentToMove) && isChildOfSegment(segmentToMove);

    const visible = active && !isRootSegmentToMove && !isEqualToSegmentToMove && !isChildOfSegmentToMove;

    let text = isUndefined(segmentToMove) ? t("tree.moveFrom") : t("tree.placeHere");

    return (
        visible && (
            <div className="MoveSegmentLabel pull-right" onClick={handleClick}>
                {text}
            </div>
        )
    );
});

export default MoveSegmentLabel;
