import React from "react";
import FontAwesome from "react-fontawesome";
import { get as _get } from "lodash";

import heuristicPic from "src/images/heuristic.png";
import interestPic from "src/images/interests.png";
import probPic from "src/images/prob.png";

import "./SegmentTypePic.scss";

const segmentTypePics = {
    HEURISTIC: heuristicPic,
    INTEREST: interestPic,
    LOOKALIKE: probPic,
};

// TODO do something with pictures loading as every loading triggers the whole segment tree rerendering :(
const SegmentTypePic = (props) => {
    const { type } = props;

    return type && _get(segmentTypePics, type) ? (
        <img className="segment-type-pic" src={segmentTypePics[type]} title={type} role="presentation" alt={type} />
    ) : (
        <FontAwesome className="segment-type-pic" title={type} name="user-circle-o" />
    );
};

export default SegmentTypePic;
