import React, { useState } from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import { isEmpty, map as _map, orderBy as _orderBy } from "lodash";
import { getNothingFoundState } from "../selectors";
import SegmentItem from "./SegmentItem";

import "./style.scss";

const SegmentsTree = connect((state) => ({
    nothingFound: getNothingFoundState(state),
}))((props) => {
    const { nothingFound } = props;

    const { t } = useTranslation("common");

    if (nothingFound) {
        return <div className="SegmentsTree-nothing-found">{t("nothingFound")}</div>;
    } else {
        return <div className="SegmentsTree">{props.children}</div>;
    }
});

const SegmentsTreeNode = (props) => {
    const { segment, level } = props;

    const [collapsed, setCollapsed] = useState(false);

    const onArrowClick = () => {
        setCollapsed(!collapsed);
    };

    let show = !isEmpty(segment) && segment.isVisible && (!segment.isDeleted)

    return show ? (
        <div>
            <SegmentItem
                key={"segment_line-" + segment.id}
                segment={segment}
                level={level}
                hasChildren={!isEmpty(segment.children)}
                collapsed={collapsed}
                onArrowClick={onArrowClick}
            />
            <div>
                {!collapsed &&
                    _map(_orderBy(segment.children, ["priority", "name"], ["desc", "asc"]), (each) => (
                        <SegmentsTreeNode key={each.id} segment={each} level={level + 1} />
                    ))}
            </div>
        </div>
    ) : (
        <div />
    );
};

export default SegmentsTree;
export { SegmentsTreeNode };
