import React, { useEffect } from "react";
import { connect } from "react-redux";
import { getMatchedSegmentsState } from "../selectors";

import { useTranslation } from "react-i18next";
import { isEmpty } from "lodash";
import { Spin } from "@lib/components/lego";
import SegmentItem from "../tree/SegmentItem";
import { matchSegmentConditions } from "../actions";
import { getCurrentUserLogin } from "../../utils/cookie";
import { getApiState } from "../../selectors";

import "./style.scss";

const UserSegmentsList = connect((state) => ({
    api: getApiState(state),
    segments: getMatchedSegmentsState(state),
}))((props) => {
    const { api, segments, dispatch } = props;

    const { t } = useTranslation("segments");

    useEffect(() => {
        dispatch(matchSegmentConditions(api, { author: getCurrentUserLogin() }));
    }, []);

    const userSegments = segments.value.filter(each => !each.isDeleted);

    const countIndicator = segments.loading ? <Spin progress size="xxs" view="default" /> : userSegments.length;

    return (
        <div className="UserSegmentsList">
            <div className="UserSegmentsList-count">
                <span className="UserSegmentsList-count-label">{t("userSegments.count")}</span>{" "}
                <span className="UserSegmentsList-count-value">{countIndicator}</span>
            </div>

            <div className="UserSegmentsList-list">
                {userSegments.map((segment, index) => {
                    return (
                        <SegmentItem
                            key={"segment_line-" + segment.id}
                            segment={segment}
                            level={0}
                            hasChildren={!isEmpty(segment.children)}
                            collapsed={false}
                            handleArrowClick={() => {
                                console.log("action disabled");
                            }}
                        />
                    );
                })}
            </div>
        </div>
    );
});

export default UserSegmentsList;
