import { isEmpty } from "lodash";

export function isActive(exportState) {
    return  ["CREATED", "ACTIVE", "DEPRECATED", "DISABLE_REQUESTED"].includes(exportState);
}

export function hasNotActiveSegmentExports(exportStates) {
    return !isEmpty(exportStates) && !exportStates.some((each) => isActive(each.state));
}

export function hasNoExports(exportStates) {
    return isEmpty(exportStates);
}

export function hasNoCoverage(exportStates) {
    return !isEmpty(exportStates) && exportStates.some((each) => each.profilesCoverage === 0 && isActive(each.state));
}

export function hasOverdue(exportStates) {
    return !isEmpty(exportStates) && exportStates.some((each) => each.overdue && isActive(each.state));
}

export function exportHasWarning(segmentExport) {
    return !isActive(segmentExport.state) || segmentExport.coverages.bigb === 0;
}
