import React from "react";
import { Button } from "@lib/components/lego";
import FontAwesome from "react-fontawesome";
import { get as _get } from "lodash";

import "./style.scss";

const ICON_NAME = {
    add: "plus",
    edit: "pencil",
    delete: "trash",
    addUser: "user-plus",
    removeUser: "user-times",
    approve: "thumbs-up",
};

function ActionButton(props) {
    const { theme, view, size, disabled, checked, onClick, title, action, text, width } = props;

    return (
        <Button
            theme={theme}
            view={view}
            size={size}
            disabled={disabled}
            checked={checked}
            onClick={onClick}
            title={title}
            width={width}
        >
            <FontAwesome name={_get(ICON_NAME, action, "question")} />
            {text && " " + text}
        </Button>
    );
}

ActionButton.defaultProps = {
    theme: "default",
    view: "action",
    size: "m",
    width: "auto",
};

export default ActionButton;
