import React from "react";
import { Button } from "@lib/components/lego";
import FontAwesome from "react-fontawesome";

import "./style.scss";
import { useTranslation } from "react-i18next";

const FinishChangesButtons = (props) => {
    const { acceptDisabled, rejectDisabled, onAccept, onReject } = props;

    const { t, i18n } = useTranslation("common");

    return (
        <span className="finish-changes-buttons">
      <span className="accept-button">
        <Button
            view="clear"
            theme="raised"
            size="s"
            pin="round-brick"
            disabled={acceptDisabled}
            title={t("actions.acceptEditing")}
            onClick={onAccept}
        >
          <FontAwesome name="check" />
        </Button>
      </span>
      <span className="reject-button">
        <Button
            view="clear"
            theme="raised"
            size="s"
            pin="brick-round"
            disabled={rejectDisabled}
            title={t("actions.rejectEditing")}
            onClick={onReject}
        >
          <FontAwesome name="remove" />
        </Button>
      </span>
    </span>
    );
};

export default FinishChangesButtons;
