import { createSelector } from "reselect";

const getLanguage = (state) => state.base.lang;
export const getLanguageState = createSelector([getLanguage], (language) => language);

const getAccess = (state) => state.base.access;
export const getAccessState = createSelector([getAccess], (access) => access);

const getApi = (state) => state.base.api;
export const getApiState = createSelector([getApi], (api) => api);

const getEnvType = (state) => state.base.envType;
export const getEnvTypeState = createSelector([getEnvType], (envType) => envType);

const getAuthUrl = (state) => state.base.authUrl;
export const getAuthUrlState = createSelector([getAuthUrl], (authUrl) => authUrl);

const getBeta = (state) => state.base.beta;
export const getBetaState = createSelector([getBeta], (beta) => beta);

const getApiInfo = (state) => state.base.apiInfo;
export const getApiBetaState = createSelector([getApiInfo], (apiInfo) => (apiInfo.host || "").includes("test"));
export const getApiVersionState = createSelector([getApiInfo], (apiInfo) => apiInfo.version);
export const getApiHostState = createSelector([getApiInfo], (apiInfo) => apiInfo.host);

const getVersion = (state) => state.base.version;
export const getVersionState = createSelector([getVersion], (version) => version);

const getNow = (state) => state.base.now;
export const getNowState = createSelector([getNow], (now) => now);

const getSrcTableColumns = (state) => state.utils;
export const getSrcTableColumnsState = createSelector([getSrcTableColumns], (data) => data);

export * from "audiences/selectors";
export * from "segments/selectors";
export * from "samples/selectors";
