import React from "react";
import { useTranslation } from "react-i18next";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faHourglassHalf } from "@fortawesome/free-solid-svg-icons";

import { Button } from "@lib/components/lego";

import "./style.scss";

const StatsNotReady = (props) => {
    const { reloadFunc } = props;

    const { t } = useTranslation("stats");

    return (
        <div className="StatsNotReady">
            <div>
                <FontAwesomeIcon className="StatsNotReady-hourglass" icon={faHourglassHalf} />
            </div>
            <div className="StatsNotReady-text">{t("notReady")}</div>
            <div>
                <Button view="action" size="m" onClick={reloadFunc}>
                    <span className="StatsNotReady-text">{t("reloadStats")}</span>
                </Button>
            </div>
        </div>
    );
};

export default StatsNotReady;
