import { createAction } from "redux-actions";

export const requestSiberiaSampleStats = createAction("request siberia sample stats");
export const receiveSiberiaSampleStats = createAction("receive siberia sample stats");
export const failedSiberiaSampleStats = createAction("failed siberia sample stats");
export const setSiberiaSampleStatsNotReady = createAction("set siberia sample stats not ready");
export const setSiberiaSampleStatsNotFound = createAction("set siberia sample stats not found");

export const requestExportUserSetId = createAction("request user set id by export id");
export const failedExportUserSetId = createAction("failed user set id by export id");



const recieveSampleStats = (dispatch, sampleStats) => {
    // FIXME throw proper status code in API, now 204 means empty stats
    if (sampleStats.status === 204) {
        const error = new Error("Not found");
        error.status = 404;
        throw error;
    }
    dispatch(receiveSiberiaSampleStats(sampleStats.obj));
};

const processSampleStatsError = (dispatch, error) => {
    if (error.status === 400 && error.response.obj.code === "NOT_READY") {
        dispatch(setSiberiaSampleStatsNotReady());
    }
    if (error.status === 404) {
        dispatch(setSiberiaSampleStatsNotFound());
    }
    dispatch(failedSiberiaSampleStats(error.status));
};


export function fetchSiberiaSampleStats(api, siberiaUserSetId, baseUserSetID) {
    return (dispatch) => {
        dispatch(requestSiberiaSampleStats(siberiaUserSetId));

        let params = {
            user_set_id: siberiaUserSetId,
            base_user_set_id: baseUserSetID,
        };

        return api
            .then((api) => api.apis.lab.getStatsFromSiberia)
            .then((method) => method(params))
            .then((sampleStats) => recieveSampleStats(dispatch, sampleStats))
            .catch((error) => processSampleStatsError(dispatch, error));
    };
}

export function fetchSiberiaSampleStatsByExportId(api, siberiaUserSetId, exportId) {
    return (dispatch) => {
        dispatch(requestExportUserSetId(exportId));

        return api
            .then((api) => api.apis.lab.getUserSetIdByExportId)
            .then((method) => method({export_id: exportId}))
            .then((payload) => payload.data)
            .then((userSetId) => dispatch(fetchSiberiaSampleStats(api, siberiaUserSetId, userSetId)))
            .catch((error) => dispatch(failedExportUserSetId(error)));
    };
}
