import React, { useState } from "react";
import { useTranslation } from "react-i18next";
import { isEmpty, sortBy as _sortBy } from "lodash";
import Autosuggest from "react-autosuggest";

import { Spin } from "@lib/components/lego";

import "./style.scss";

const GroupSuggest = (props) => {
    const { sampleGroups, onChange, onSuggestionSelected, activeGroup, isLoading } = props;

    const [suggestions, setSuggestions] = useState([]);

    const { t } = useTranslation("stats");

    const onChange_ = (event, { newValue }) => {
        onChange(newValue);
    };

    const onSuggestionsFetchRequested = ({ value }) => {
        setSuggestions(getSuggestions(value));
    };

    const onSuggestionsClearRequested = () => {
        setSuggestions([]);
    };

    const getSuggestions = (value) => {
        const inputValue = value.trim().toLowerCase();
        const inputLength = inputValue.length;
        let suggestions = sampleGroups;

        if (inputLength !== 0) {
            suggestions = _sortBy(sampleGroups, "length").filter((each) => each.toLowerCase().includes(inputValue));
        }

        if (isEmpty(suggestions)) {
            suggestions.push(inputValue);
        }

        return suggestions.slice(0, 150);
    };

    const renderSuggestion = (suggestion) => <div>{suggestion}</div>;

    const onSuggestionSelected_ = (event, { suggestionValue }) => {
        onSuggestionSelected(suggestionValue);
    };

    const getSuggestionValue = (suggestion) => suggestion;

    const value = activeGroup;
    const inputProps = {
        placeholder: t("subsamplePlaceholder"),
        value,
        onChange: onChange_,
        disabled: sampleGroups.length === 0,
    };

    return (
        <span className="GroupSuggest">
            <Autosuggest
                suggestions={suggestions}
                onSuggestionsFetchRequested={onSuggestionsFetchRequested}
                onSuggestionsClearRequested={onSuggestionsClearRequested}
                onSuggestionSelected={onSuggestionSelected_}
                getSuggestionValue={getSuggestionValue}
                renderSuggestion={renderSuggestion}
                inputProps={inputProps}
                shouldRenderSuggestions={() => true}
                highlightFirstSuggestion={true}
            />
            {isLoading && <Spin progress size="xxs" />}
        </span>
    );
};

export default GroupSuggest;
