import React from "react";
import FontAwesome from "react-fontawesome";
import { useTranslation } from "react-i18next";
import { Attach } from "@yandex-lego/components/Attach/desktop/bundle";
import { Select, TextInput } from "@lib/components/lego";
import Link from "@lib/components/link";
import ValidableYtPath from "../../utils/ValidableYtPath";

const TABLE = "TABLE";
const FILE = "FILE";
const AUDIENCE = "AUDIENCE";

const YT_PATH_PLACEHOLDER = "//path/to/mySuperCoolSample";
const AUDIENCE_ID_PLACEHOLDER = "00000000";
const TEXT_INPUT_SIZE = "m";

const InputRow = (props) => {
    const { inputType, path, audienceSegment, disabled, onParameterChange } = props;
    const { t } = useTranslation("trainingSamples");

    let inputOptions = [
        { value: TABLE, content: t("create.sampleTable") },
        { value: FILE, content: t("create.file") },
        { value: AUDIENCE, content: t("create.audienceSegment") },
    ];

    const LABORATORY_TRAINING_SAMPLES_SOURCE_HELP_URL = "https://docs.yandex-team.ru/crypta/lab/training_samples";

    return (
        <tr>
            <td className="sample-param-label">
                <div className="sample-param-label-with-tooltip">
                    <span className="sample-param-label-help-input">
                        <Link
                            className="sample-param-label-help-input-link"
                            href={LABORATORY_TRAINING_SAMPLES_SOURCE_HELP_URL}
                            title={t("create.sourceGuide")}
                            target="_blank"
                        >
                            <FontAwesome className="sample-param-label-help-input-link-pic" name="info-circle" />
                        </Link>
                    </span>
                    <span className="sample-param-label-help-input-selector">
                        <Select
                            view="default"
                            size={TEXT_INPUT_SIZE}
                            width="fixed"
                            value={inputType}
                            onChange={(event) => onParameterChange(event.target.value, "inputType")}
                            options={inputOptions}
                        />
                    </span>
                </div>
            </td>
            <td className="sample-param-value">
                {inputType === TABLE && (
                    <span>
                        <ValidableYtPath>
                            <TextInput
                                view="default"
                                theme="normal"
                                size={TEXT_INPUT_SIZE}
                                hasClear
                                value={path}
                                placeholder={YT_PATH_PLACEHOLDER}
                                onChange={(event) => onParameterChange(event.target.value, "path")}
                                disabled={disabled}
                            />
                        </ValidableYtPath>
                    </span>
                )}
                {inputType === AUDIENCE && (
                    <span>
                        <span className="audience-id">
                            <TextInput
                                view="default"
                                theme="normal"
                                size={TEXT_INPUT_SIZE}
                                value={audienceSegment}
                                placeholder={AUDIENCE_ID_PLACEHOLDER}
                                onChange={(event) => onParameterChange(event.target.value, "audienceSegment")}
                                disabled={disabled}
                            />
                        </span>
                    </span>
                )}
                {inputType === FILE && (
                    <span>
                        <Attach
                            theme="normal"
                            size="m"
                            name="File"
                            hasHolder={true}
                            accept=".csv"
                            onChange={(event) => onParameterChange(event.target.files[0], "file")}
                            disabled={disabled}
                        >
                            {t("create.selectFile")}
                        </Attach>
                    </span>
                )}
            </td>
        </tr>
    );
};

export default InputRow;
