import React from "react";
import FontAwesome from "react-fontawesome";
import { Button, TooltipStateful } from "@lib/components/lego";

const InputTooltip = (props) => {
    const { content } = props;

    return (
        <TooltipStateful size="s" view="default" content={content}>
            <Button view="clear" theme="clear" size="ss">
                <FontAwesome key="metrics" className="TrainingSampleButton" name="info-circle" />
            </Button>
        </TooltipStateful>
    );
};

export default InputTooltip;
