import React, { useEffect } from "react";
import { useFetching } from "../actions";
import { Select } from "@lib/components/lego";
import { useTranslation } from "react-i18next";

const TEXT_INPUT_SIZE = "m";

const ModelSelector = (props) => {
    const { api, activeModel, onModelSelect } = props;
    const { t } = useTranslation("trainingSamples");

    const [industriesFetching, isLoading, isFailed, error, models] = useFetching(
        api,
        (api) => api.apis.lab.getTrainingSamplesIndustries,
        {
            isLoading: true,
            isFailed: false,
            error: undefined,
            data: [],
        }
    );

    useEffect(() => {
        industriesFetching();
    }, []);

    let inputOptions = Object.values(models).map((each) => {
        return { value: each.modelName, content: each.name };
    });

    let activeModelInfo = Object.values(models).filter((each) => each.modelName === activeModel)[0];

    return (
        <tr>
            <td className="sample-param-label">
                <Select
                    view="default"
                    size={TEXT_INPUT_SIZE}
                    placeholder={t("selectModel")}
                    width="fixed"
                    value={activeModel}
                    onChange={(event) => onModelSelect(event.target.value)}
                    options={_.sortBy(inputOptions, "content")}
                />
            </td>
            <td className="sample-param-value">
                {activeModel ? (
                    <table key="model-description">
                        <tbody>
                            <tr key="objective">
                                <td className="description-key">Оптимизируем:</td>
                                <td>{activeModelInfo.objective}</td>
                            </tr>
                            <tr key="positive-conv">
                                <td className="description-key">Положительные конверсии:</td>
                                <td>{activeModelInfo.positiveConversions}</td>
                            </tr>
                            <tr key="negative-conv">
                                <td className="description-key">Отрицательные конверсии:</td>
                                <td>{activeModelInfo.negativeConversions}</td>
                            </tr>
                        </tbody>
                    </table>
                ) : (
                    <div>Описание</div>
                )}
            </td>
        </tr>
    );
};

export default ModelSelector;
