import React, { Component } from "react";
import { withTranslation } from "react-i18next";
import AccessLevelSelect from "../../samples/AccessLevelSelect";
import { TextInput } from "@lib/components/lego";
import InputRow from "./InputRow";
import ModelSelector from "./ModelSelector";
import InputTooltip from "./InputTooltip";

import "../styles/CreateSampleModal.scss";

const TEXT_INPUT_SIZE = "m";
const TTL_PLACEHOLDER = "7";
const SEGMENT_SIZE_PLACEHOLDER = "100000";

@withTranslation("createSample")
class ImportTrainingSampleParams extends Component {
    render() {
        const {
            api,
            isNewModel,
            name,
            inputType,
            path,
            audienceSegment,
            modelName,
            partner,
            positiveSegmentSize,
            negativeSegmentSize,
            ttl,
            loginsToShare,
            accessLevel,
            disabled,
            isAdmin,
            t,
        } = this.props;

        return (
            <div className="import-sample-params">
                <table className="sample-params-table">
                    <tbody>
                        {!isNewModel && (
                            <ModelSelector
                                api={api}
                                activeModel={modelName}
                                onModelSelect={(value) => this.props.onParameterChange(value, "modelName")}
                            />
                        )}
                        <tr>
                            <td className="sample-param-label">{t("name")}</td>
                            <td className="sample-param-value">
                                <TextInput
                                    state={name ? undefined : "error"}
                                    view="default"
                                    theme="normal"
                                    size={TEXT_INPUT_SIZE}
                                    hasClear
                                    value={name}
                                    placeholder={t("namePlaceholder")}
                                    onChange={(event) => this.props.onParameterChange(event.target.value, "name")}
                                    disabled={disabled}
                                />
                            </td>
                        </tr>
                        <InputRow
                            onParameterChange={(value, type) => this.props.onParameterChange(value, type)}
                            inputType={inputType}
                            path={path}
                            audienceSegment={audienceSegment}
                            disabled={disabled}
                        />
                        {isNewModel && (
                            <tr>
                                <td className="sample-param-label">
                                    <div className="sample-param-label-with-tooltip">
                                        <span className="sample-param-label-help">
                                            <InputTooltip content={t("tooltip.positiveSegmentSize")} />
                                        </span>
                                        <span className="sample-param-label-name">{t("positiveSegmentSize")}</span>
                                    </div>
                                </td>
                                <td className="sample-param-value">
                                    <span className="positive-segment-size">
                                        <TextInput
                                            view="default"
                                            theme="normal"
                                            size={TEXT_INPUT_SIZE}
                                            value={positiveSegmentSize}
                                            placeholder={SEGMENT_SIZE_PLACEHOLDER}
                                            onChange={(event) =>
                                                this.props.onParameterChange(event.target.value, "positiveSegmentSize")
                                            }
                                            disabled={disabled}
                                        />
                                    </span>
                                </td>
                            </tr>
                        )}
                        {isNewModel && (
                            <tr>
                                <td className="sample-param-label">
                                    <div className="sample-param-label-with-tooltip">
                                        <span className="sample-param-label-help">
                                            <InputTooltip content={t("tooltip.negativeSegmentSize")} />
                                        </span>
                                        <span className="sample-param-label-name">{t("negativeSegmentSize")}</span>
                                    </div>
                                </td>
                                <td className="sample-param-value">
                                    <span className="negative-segment-size">
                                        <TextInput
                                            view="default"
                                            theme="normal"
                                            size={TEXT_INPUT_SIZE}
                                            value={negativeSegmentSize}
                                            placeholder={SEGMENT_SIZE_PLACEHOLDER}
                                            onChange={(event) =>
                                                this.props.onParameterChange(event.target.value, "negativeSegmentSize")
                                            }
                                            disabled={disabled}
                                        />
                                    </span>
                                </td>
                            </tr>
                        )}
                        {!isNewModel && (
                            <tr>
                                <td className="sample-param-label">
                                    <div className="sample-param-label-with-tooltip">
                                        <span className="sample-param-label-help">
                                            <InputTooltip content={t("tooltip.partner")} />
                                        </span>
                                        <span>{t("partner")}</span>
                                    </div>
                                </td>
                                <td className="sample-param-value">
                                    <span className="partner">
                                        <TextInput
                                            state={partner ? undefined : "error"}
                                            view="default"
                                            theme="normal"
                                            size={TEXT_INPUT_SIZE}
                                            value={partner}
                                            onChange={(event) =>
                                                this.props.onParameterChange(event.target.value, "partner")
                                            }
                                            disabled={disabled}
                                        />
                                    </span>
                                </td>
                            </tr>
                        )}
                        {!isNewModel && (
                            <tr>
                                <td className="sample-param-label">
                                    <div className="sample-param-label-with-tooltip">
                                        <span className="sample-param-label-help">
                                            <InputTooltip content={t("tooltip.loginsToShare")} />
                                        </span>
                                        <span>{t("loginsToShare")}</span>
                                    </div>
                                </td>
                                <td className="sample-param-value">
                                    <span className="logins-input">
                                        <TextInput
                                            view="default"
                                            theme="normal"
                                            size={TEXT_INPUT_SIZE}
                                            value={loginsToShare}
                                            onChange={(event) =>
                                                this.props.onParameterChange(event.target.value, "loginsToShare")
                                            }
                                            disabled={disabled}
                                        />
                                    </span>
                                </td>
                            </tr>
                        )}
                        <tr>
                            <td className="sample-param-label">
                                <div className="sample-param-label-with-tooltip">
                                    <span className="sample-param-label-help">
                                        <InputTooltip content={t("tooltip.ttl")} />
                                    </span>
                                    <span>
                                        {t("storeFor")} ({t("days")})
                                    </span>
                                </div>
                            </td>
                            <td className="sample-param-value">
                                <span className="ttl-input">
                                    <TextInput
                                        view="default"
                                        theme="normal"
                                        size={TEXT_INPUT_SIZE}
                                        value={ttl}
                                        placeholder={TTL_PLACEHOLDER}
                                        onChange={(event) => this.props.onParameterChange(event.target.value, "ttl")}
                                        disabled={disabled}
                                    />
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td className="sample-param-label">{t("access")}</td>
                            <td className="sample-param-value">
                                <AccessLevelSelect
                                    value={accessLevel}
                                    onChange={(value) => this.props.onParameterChange(value, "accessLevel")}
                                    isAdmin={isAdmin}
                                />
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        );
    }
}

export default ImportTrainingSampleParams;
