import React from "react";
import { useTranslation } from "react-i18next";
import { Select } from "@lib/components/lego";

const INITIAL_NEGATIVE = "initial_negative";
const INITIAL_POSITIVE = "initial_positive";
const MODELED_NEGATIVE = "modeled_negative";
const MODELED_POSITIVE = "modeled_positive";

const TEXT_INPUT_SIZE = "m";

const SegmentSelector = (props) => {
    const { activeSegment, onSegmentSelect } = props;
    const { t } = useTranslation("trainingSamples");

    const inputOptions = [
        { value: INITIAL_NEGATIVE, content: t(`segments.${INITIAL_NEGATIVE}`) },
        { value: INITIAL_POSITIVE, content: t(`segments.${INITIAL_POSITIVE}`) },
        { value: MODELED_NEGATIVE, content: t(`segments.${MODELED_NEGATIVE}`) },
        { value: MODELED_POSITIVE, content: t(`segments.${MODELED_POSITIVE}`) },
    ];

    return (
        <Select
            view="default"
            size={TEXT_INPUT_SIZE}
            placeholder={t("segments.selectSegment")}
            width="max"
            value={activeSegment}
            onChange={(event) => onSegmentSelect(event.target.value)}
            options={inputOptions}
        />
    );
};

export default SegmentSelector;
