import React from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import { Button, RadioButton } from "@lib/components/lego";
import TableRow from "./TableRow";
import CreateTrainingSampleModal from "./CreateSampleModal";
import { getTrainingSamplesState } from "../selectors";
import { openCreateSampleModal, openUpdateSampleModal, selectTrainingSamplesType } from "../actions";

import "../styles/Table.scss";

const CreateSampleButton = connect((state) => ({
    isCreateSampleModalVisible: getTrainingSamplesState(state).modals.createSample,
    samplesType: getTrainingSamplesState(state).type,
}))((props) => {
    const { isCreateSampleModalVisible, samplesType, dispatch } = props;
    const { t } = useTranslation("trainingSamples");

    return (
        <div className="TrainingSamplesHeader">
            <div className="TrainingSamplesHeader-internal">
                <RadioButton
                    value={samplesType}
                    view="default"
                    size="s"
                    onChange={(event) => dispatch(selectTrainingSamplesType(event.target.value))}
                    options={[
                        { value: "forNewModel", children: t("menu.newSample") },
                        { value: "toUpdateModel", children: t("menu.updateSample") },
                    ]}
                />
                <Button view="action" theme="action" size="s" onClick={() => dispatch(openCreateSampleModal())}>
                    <FontAwesome name="plus" />
                    {"  "}
                    {t("createTrainingSample")}
                </Button>
                <Button view="action" theme="action" size="s" onClick={() => dispatch(openUpdateSampleModal())}>
                    <FontAwesome name="plus" />
                    {"  "}
                    {t("createTrainingSampleExistingModel")}
                </Button>
            </div>
            {isCreateSampleModalVisible && <CreateTrainingSampleModal />}
        </div>
    );
});

const TrainingSamplesTableHeader = () => {
    const { t } = useTranslation("samples");

    return (
        <tr className="TrainingSamplesTableHeader">
            <th key="id">{t("headers.id")}</th>
            <th key="name">{t("headers.name")}</th>
            <th key="status">{t("headers.status")}</th>
            <th key="author">{t("headers.author")}</th>
            <th key="created">{t("headers.created")}</th>
            <th key="accessLevel">{t("headers.access")}</th>
            <th key="buttons"> </th>
        </tr>
    );
};

const TrainingSamplesTable = connect((state) => ({
    samples: getTrainingSamplesState(state).samples,
    samplesType: getTrainingSamplesState(state).type,
}))((props) => {
    const { samples, samplesType } = props;

    return (
        <div className="Navigation">
            <CreateSampleButton />
            <table className="TrainingSamplesTable">
                <thead>
                    <TrainingSamplesTableHeader key="header" />
                </thead>
                <tbody>
                    {samples[samplesType].map((each) => {
                        return <TableRow key={each.id} sample={each} sampleType={samplesType} />;
                    })}
                </tbody>
            </table>
        </div>
    );
});

export default TrainingSamplesTable;
