import React from "react";
import { useDispatch } from "react-redux";
import FontAwesome from "react-fontawesome";
import { useTranslation } from "react-i18next";
import { Button, TooltipStateful } from "@lib/components/lego";
import Id from "../../utils/Id";
import User from "../../utils/User";
import SimpleDate from "../../utils/SimpleDate";
import LabLink from "../../utils/LabLink";
import { selectAndOpenMetricsModal, selectAndOpenStatsModal } from "../actions";

import "../styles/Table.scss";

const TableRow = (props) => {
    const { sample, sampleType } = props;

    const { t, i18n } = useTranslation("samples");
    const lang = i18n.language;

    const dispatch = useDispatch();

    return (
        <tr className="TrainingSamplesTableRow">
            <td key="id" className="SampleId">
                <Id copyable={true} value={sample.id} />
            </td>
            <td key="name" className="SampleName" title={sample.name.length > 30 ? sample.name : ""}>
                {sample.name}
            </td>
            <td key="status">
                <Button view="clear" theme="pseudo" size="s">
                    {sample.status}
                </Button>
            </td>
            <td key="author" className="SampleAuthor">
                <User login={sample.author} />
            </td>
            <td key="created" className="SampleCreated">
                <SimpleDate lang={lang} value={sample.timestamps.created} />
            </td>
            <td key="accessLevel" className="SampleAccessLevel">
                <div className="SampleAccessLevel-content">
                    {t(`access.${sample.accessLevel}`)}
                    {["SHARED", "PUBLIC"].includes(sample.accessLevel) && <LabLink search={"sample=" + sample.id} />}
                </div>
            </td>
            <td key="buttons">
                <TooltipStateful size="s" view="default" content={t("headers.metrics")}>
                    <Button
                        view="clear"
                        theme="pseudo"
                        size="s"
                        onClick={() => dispatch(selectAndOpenMetricsModal(sample.id))}
                    >
                        <FontAwesome key="metrics" className="TrainingSampleButton" name="info-circle" />
                    </Button>
                </TooltipStateful>
                {sampleType === "forNewModel" && (
                    <TooltipStateful size="s" view="default" content={t("headers.segmentsStats")}>
                        <Button
                            view="clear"
                            theme="pseudo"
                            size="s"
                            onClick={() => dispatch(selectAndOpenStatsModal(sample.id))}
                        >
                            <FontAwesome key="stats" className="TrainingSampleButton" name="bar-chart" />
                        </Button>
                    </TooltipStateful>
                )}
                {sample.trainingError && (
                    <TooltipStateful size="s" view="default" content={sample.trainingError} state="alert">
                        <Button view="clear" theme="pseudo" size="s">
                            <FontAwesome key="stats" className="TrainingSampleButton-error" name="exclamation-circle" />
                        </Button>
                    </TooltipStateful>
                )}
            </td>
        </tr>
    );
};

export default TableRow;
