import { getApiState } from "../selectors";
import { useTranslation } from "react-i18next";
import { fetchTrainingSamples, getSampleById } from "./actions";
import React, { useEffect } from "react";
import { getSelectedTrainingSampleId, getTrainingSamplesState } from "./selectors";
import { connect } from "react-redux";
import TrainingSamplesTable from "./components/Table";
import Failable from "../utils/Failable";
import Loading from "@lib/components/loading";
import SegmentsStatsModal from "./components/SegmentsStatsModal";
import MetricsModal from "./components/MetricsModal";

const TrainingSamples = connect((state) => ({
    api: getApiState(state),
    failed: getTrainingSamplesState(state).failed,
    loaded: getTrainingSamplesState(state).loaded,
    samples: getTrainingSamplesState(state).samples,
    message: getTrainingSamplesState(state).message,
    selected: getSelectedTrainingSampleId(state),
    location: state.router.location,
    isStatsModalVisible: getTrainingSamplesState(state).modals.showStats,
    isMetricsModalVisible: getTrainingSamplesState(state).modals.showMetrics,
}))((props) => {
    const { api, samples, selected, failed, loaded, message, isStatsModalVisible, isMetricsModalVisible, dispatch } =
        props;
    const { i18n } = useTranslation();
    const lang = i18n.language;

    const fetch = () => {
        dispatch(
            fetchTrainingSamples({
                api: api,
                lang: lang,
                selected: selected,
            })
        );
    };

    useEffect(() => {
        fetch();
    }, []);

    const getSelectedSampleById = (sampleId) => {
        if (samples) {
            for (let sampleType in samples) {
                let sample = getSampleById(samples[sampleType], sampleId);
                if (sample) {
                    return sample;
                }
            }
        }
    };

    let selectedSample = getSelectedSampleById(selected);

    return (
        <Failable failed={failed} errorMessage={message} retry={fetch}>
            <Loading loaded={loaded}>
                <div>
                    <TrainingSamplesTable />
                    {isStatsModalVisible && <SegmentsStatsModal sample={selectedSample} />}
                    {isMetricsModalVisible && <MetricsModal sample={selectedSample} />}
                </div>
            </Loading>
        </Failable>
    );
});

export default TrainingSamples;
